# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Devel/PPPort.pm) perl(Errno.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FindBin.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(Test/Warn.pm) perl(Tie/Handle.pm) perl(XSLoader.pm) perl(YAML/Tiny.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name warnings-unused
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt7
Summary: Produces warnings when unused variables are detected
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GF/GFUJI/%module_name-%module_version.tar.gz

%description
Note: The author no longer maintain this module. Consider the Test::Vars manpage if you detect unused vars as a unit test.

This pragmatic module extends lexical warnings to complain about unused
variables.

It produces warnings when a `my' variable or `state' variable is unused aside
from its declaration.

Given you write a subroutine like this:

	sub f{
		my($x, $y, $z) = @_;
		$y++;             # used
		return sub{ $z }; # used
	}

The code above will be complained about `$x', because it is used nowhere
aside from its declaration.

You should write `f()' like this:

	sub f{
		my(undef, $y, $z) = @_;
		$y++;             # used
		return sub{ $z }; # used
	}

Here, one will see the obvious intention to ignore the first argument of
`f()'.

The check routine works only at the compile time, so it affect nothing
about the run time.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes example
%perl_vendor_archlib/w*
%perl_vendor_autolib/*

%changelog
