Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           pgdbf
Version:        0.6.2
Release:        alt2_11
Summary:        Convert XBase / FoxPro databases to PostgreSQL

License:        GPLv3+
URL:            https://github.com/kstrauser/pgdbf
Source0:        https://github.com/kstrauser/%{name}/archive/v%{version}/%{name}-%{version}.tar.gz

BuildRequires:  libtool autoconf automake gettext-tools libasprintf-devel
Source44: import.info

%description
PgDBF is a program for converting XBase databases - particularly FoxPro tables
with memo files - into a format that PostgreSQL can directly import. It's a
compact C project with no dependencies other than standard Unix libraries.

While the project is relatively tiny and simple, it's also heavily optimized
via profiling - routine benchmark were many times faster than with other Open
Source programs. In fact, even on slower systems, conversions are typically
limited by hard drive speed.

%prep
%setup -q



%build
libtoolize --force
aclocal
autoheader
automake --force-missing --add-missing
autoconf
%configure --docdir=%{_docdir}/%{name}
%make_build

%install
%makeinstall_std

# Remove installed documentation (unversioned dir)
rm -rvf %{buildroot}%{_docdir}/%{name}

%files
%doc --no-dereference COPYING
%doc README
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*

%changelog
