# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	A Chess Engine
Name:		phalanx
Version:	25
Release:	alt1_2
License:	GPLv2
Group:		Games/Boards
URL:		https://phalanx.sourceforge.net/
Source0:	https://sourceforge.net/projects/phalanx/files/Version%%20XXV/phalanx-XXV-source.tgz
Source1:	sbook.phalanx.bz2
Source2:	learn.phalanx.bz2
Source3:	phalanx.sh.bz2
Source44: import.info

# TODO: either exclusivearch or regen opening books.
#       phalanx opening books are big/little endian sensitive

%description
Phalanx is a chess engine. It contains a text interface for playing
chess. Though it does not have any graphical interface, one can use
it inside some GUI chess interface such as Xboard or CSBoard,
serving as a chess engine.


%prep
%setup -q -n Phalanx-XXV
#patch -P 0 -p1 -b .newgcc
#patch -P 1 -p0

mv sbook.phalanx sbook.phalanx.bak
bzip2 -dc %{SOURCE1} > sbook.phalanx
bzip2 -dc %{SOURCE2} > learn.phalanx
bzip2 -dc %{SOURCE3} > phalanx.sh

%build
%make_build	CFLAGS='%optflags -ffast-math' \
		DEFINES='-DGNUFUN -DPBOOK_DIR=\"%{_gamesdatadir}/%{name}\" -DSBOOK_DIR=\"%{_gamesdatadir}/%{name}\" -DECO_DIR=\"%{_gamesdatadir}/%{name}\"'

%install

install -D -m 755 phalanx %{buildroot}%{_gamesbindir}/phalanx.real
install -D -m 755 phalanx.sh %{buildroot}%{_gamesbindir}/phalanx

# install opening books
mkdir -p %{buildroot}%{_gamesdatadir}/%{name}
install -m 644 eco.phalanx pbook.phalanx sbook.phalanx learn.phalanx %{buildroot}%{_gamesdatadir}/%{name}/

%files
%doc HISTORY README
%{_gamesbindir}/*
%{_gamesdatadir}/%{name}


%changelog
