Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 4

Summary:        Graphical tool to make photo collage posters
Name:           photocollage
Version:        1.4.7
Release:        alt1_4
Url:            https://github.com/adrienverge/PhotoCollage
# SPDX
License:        GPL-2.0-only

Source0:        https://github.com/adrienverge/PhotoCollage/archive/v%{version}/%{name}-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  python3-devel >= 3.5
BuildRequires:  python3-module-pkg_resources python3-module-setuptools
BuildRequires:  gettext-tools
BuildRequires:  desktop-file-utils

Requires:       python3-module-Pillow >= 2.0
Requires:       python3-module-pycairo >= 1.10
Requires:       python3-module-pygobject3 >= 3.0
Requires:       python3-module-six
Requires:       gettext >= 0.18
Source44: import.info

%description
PhotoCollage allows you to create photo collage posters. It assembles
the input photographs it is given to generate a big poster. Photos are
automatically arranged to fill the whole poster, then you can change the
final layout, dimensions, border or swap photos in the generated grid.
Eventually the final poster image can be saved in any size.

%prep
%setup -q -n photocollage-%{version}


%build
%{__python3} setup.py build

%install
%{__python3} setup.py install -O1 --root %{buildroot}
%find_lang %{name}
desktop-file-validate %{buildroot}%{_datadir}/applications/%{name}.desktop

%files -f %{name}.lang
%doc README.rst
%doc --no-dereference LICENSE
%{python3_sitelibdir_noarch}/*
%{_bindir}/photocollage
%{_datadir}/applications/%{name}.desktop
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/icons/hicolor/scalable/apps/%{name}.svg
%{_datadir}/icons/hicolor/*/apps/%{name}.png

%changelog
