Group: Networking/WWW
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           plowshare
Version:        2.0.1
Release:        alt2_10
Summary:        Download and upload files from file-sharing websites
Summary(pt_BR): Baixe e carregue arquivos em sites de compartilhamento
Summary(ru):    терминальный аплоадер/доунлоадер для наиболее популярных файлообменников
License:        GPLv3+
URL:            http://plowshare.googlecode.com
Source0:        https://plowshare.googlecode.com/archive/v%{version}.tar.gz


BuildRequires: git

Requires:  curl
Requires:  caca-utils
Requires:  recode
Requires:  js

BuildArch: noarch
Source44: import.info

%description
plowshare is a command-line downloader/uploader for some of the most popular
file-sharing websites. It works on UNIX-like systems and presently supports
Megaupload, Rapidshare, 2Shared, 4Shared, ZShare, Badongo, Depositfiles,
Mediafire, Netload.in, Storage.to, Uploaded.to, Uploading.com, Sendspace,
Usershare, X7.to and others.

%description -l pt_BR
plowshare é um cliente em linha de comando para baixar/carregar arquivos nos
mais populares sites de compartilhamento. Funciona em sistemas Unix-like e
atualmente suporta o Megaupload, RapidShare, 2Shared, 4Shared, Zshare, Badongo,
Depositfiles, Mediafire, Netload.in, Storage.to, Uploaded.to, Uploading.com,
Sendspace, Usershare, X7.to e outros.

%description -l ru
plowshare это терминальный аплоадер/доунлоадер для наиболее популярных файло-
обменников. Он работает на большинстве UNIX-подобных систем. На данный момент
поддерживаются следующие сервисы: Megaupload, Rapidshare, 2Shared, 4Shared,
ZShare, Badongo, DepositFiles и Mediafire. Смотрите README для подробностей.

%prep
%setup -q -n %{name}-v%{version}

%build
# Nothing to build, it's simple bash scripts

%install
export PLOWSHARE_FORCE_VERSION=%{version}
make PREFIX=%{_prefix} DESTDIR=%{buildroot} install

# We remove at destination, so we still have install
# for the doc section
rm -rf %{buildroot}%{_docdir}/%{name}4

%files
%doc AUTHORS README COPYING
%{_bindir}/*
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/*
%{_datadir}/bash-completion/
%{_mandir}/man1/*
%{_mandir}/man5/%{name}.conf.5*

%changelog
