# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

Name:           pngcheck
Version:        3.0.3
Release:        alt1_2
Summary:        PNG file format checker
License:        MIT and GPLv2+
Group:          Graphics
Url:            http://www.libpng.org/pub/png/apps/pngcheck.html
Source0:        http://www.libpng.org/pub/png/src/%{name}-%{version}.tar.gz
Source1:        %{name}.1.gz
Patch0:         pngcheck-2.4.0-debug.patch

BuildRequires:  pkgconfig(zlib)
Source44: import.info

%description
pngcheck verifies the integrity of PNG, JNG and MNG files (by checking the
internal 32-bit CRCs or checksums) and optionally dumps almost all of the
chunk-level information in the image in human-readable form. For example, it
can be used to print the basic stats about an image (dimensions, bit depth,
etc.); to list the color and transparency info in its palette; or to extract
the embedded text annotations. All PNG and JNG chunks are supported, plus
almost all MNG chunks (everything but PAST, DISC, tERm, DROP, DBYK, and
ORDR). This is a command-line program with batch capabilities (e.g.,
``pngcheck *.png'').

%prep
%setup -q
%patch0 -p1


%build

%make_build -f Makefile.unx

%install
install -m 755 -d %{buildroot}%{_bindir}
install -m 755 %{name} %{buildroot}%{_bindir}/
install -m 755 pngsplit %{buildroot}%{_bindir}/
install -m 755 png-fix-IDAT-windowsize %{buildroot}%{_bindir}/
install -m 755 -d %{buildroot}%{_mandir}/man1/
install -m 0644 %{SOURCE1} %{buildroot}%{_mandir}/man1/

%files
%doc CHANGELOG README gpl/COPYING LICENSE
%{_bindir}/*
%{_mandir}/man1/%{name}.1*


%changelog
