# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%add_optflags -fcommon

Name:           polyglot
Version:        1.4.70b
Release:        alt1_10
Summary:        Xboard protocol to UCI protocol adapter
License:        GPLv2+
Group:          Games/Boards
URL:            http://hardy.uhasselt.be/Toga/polyglot-release/
Source0:        http://hardy.uhasselt.be/Toga/polyglot-release/%{name}-%{version}.tar.gz
Source44: import.info

%description
PolyGlot as adapter and book engine

PolyGlot is a "UCI adapter".  It connects a GUI interface (such as
XBoard, Winboard, Arena or Chessbase) to a UCI chess engine.

By specifying an opening book (in PolyGlot book format) chess engines
can transparently use such books.

PolyGlot understands the two main GUI protocols: UCI and xboard.
Normally the protocol will be auto detected but this can be overridden
in the configuration file.

In xboard mode PolyGlot fully translates between the xboard and UCI
protocols.  In addition it tries to solve known problems with other
adapters.  For instance, it detects and reports draws by fifty-move
rule, repetition, etc ... It also supports Chess960.

When in UCI mode PolyGlot mostly passes commands from the GUI to the
engine and vice versa, except that it will play book moves on behalf of
the engine when the occasion arises.

The engine options are exported as UCI options in UCI mode and as
"feature option=" commands in xboard mode. The latter form an extension
of the xboard protocol as defined by H.G. Muller.

Options which normally appear in the [PolyGlot] section of the config
file (see below) are exported as options with their name prefixed by
"Polyglot". This makes it easy to filter them in the GUI.


%prep
%setup -q

%build
%configure --bindir=%{_gamesbindir} --datadir=%{_gamesdatadir}
%make_build

%install
%makeinstall_std

rm -fr %{buildroot}%{_docdir}/%{name}

%files
%doc AUTHORS ChangeLog INSTALL NEWS TODO README* book_format.html
%{_gamesbindir}/*
%{_mandir}/man6/%{name}.6*


%changelog
