# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: /usr/bin/desktop-file-install gcc-c++ unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		posterazor
Version:	1.5.1
Release:	alt1_4
Summary:	Make your own poster
Group:		Publishing
License:	GPLv3+
URL:		http://posterazor.sourceforge.net
Source0:	https://prdownloads.sourceforge.net/%{name}/PosteRazor-%{version}-Source.zip
Source1:	%{name}.desktop
Patch0:		posterazor-1.5-format-security.patch
Patch1:		posterazor-1.5-ftbfs-gcc-4.7.patch
BuildRequires:	cmake
BuildRequires:	libfreeimage-devel
BuildRequires:	libfltk-devel
BuildRequires:	pkgconfig(xpm)
Source44: import.info

%description
The PosteRazor cuts a raster image into pieces which can afterwards be
printed out and assembled to a poster. As input, the PosteRazor takes a
raster image. The resulting poster is saved as a multipage PDF document.
An easy to use, wizard like user interface guides through 5 steps.

%prep
%setup -q -c
%patch0 -p1
%patch1 -p1


# fix wrong-file-end-of-line-encoding
for i in CHANGES LICENSE README
do
 sed -e 's/\r//' $i > $i.tmp
 touch -c -r $i $i.tmp
 mv $i.tmp $i
done

# add default constructor for translation classes (required by GCC 4.6)
for i in French English German Italian Dutch BrazilianPortuguese
do
 sed -i -e "/public:/a Translation$i\(\){}" src/Translation$i.h
done

%build
%global _vpath_srcdir src
%{mageia_cmake}
%mageia_cmake_build

%install
# binary
mkdir -p %{buildroot}%{_bindir}
install -pm 755 build/PosteRazor %{buildroot}%{_bindir}/

# icon
mkdir -p %{buildroot}%{_datadir}/pixmaps/
install -pm 644 src/PosteRazor.xpm %{buildroot}%{_datadir}/pixmaps/%{name}.xpm

# desktop file
desktop-file-install --mode 644 --dir %{buildroot}%{_datadir}/applications/ %{SOURCE1}

%files
%doc CHANGES README
%doc --no-dereference LICENSE
%{_bindir}/PosteRazor
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/%{name}.xpm


%changelog
