Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/iconv
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           powwow
Version:        1.2.23
Release:        alt1_10
Summary:        A console MUD client

# Automatically converted from old format: GPLv2+ - review is highly recommended.
License:        GPL-2.0-or-later
URL:            http://hoopajoo.net/projects/powwow.html
Source:         http://hoopajoo.net/static/projects/%{name}-%{version}.tar.gz

BuildRequires:  gcc
BuildRequires:  libncurses++-devel libncurses++w-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
BuildRequires:  libpcre-devel libpcrecpp-devel
Source44: import.info

%description
Powwow is a powerful console MUD client that supports triggers, aliases,
multiple connections, and more. It is primarily designed for DikuMUDs, but
nothing prevents its use for other types of MUDs. This client is also
extensible through a plugin interface.


%package devel
Group: Other
Summary:        Development files for powwow
Requires:       %{name} = %{version}-%{release}

%description devel
The powwow-devel package contains the headers files and developer docs
for developing applications which use powwow plugin interface.


%prep
%setup -q

# Convert to utf-8
for file in README doc/powwow.doc; do
    mv $file timestamp
    iconv -f ISO-8859-1 -t UTF-8 -o $file timestamp
    touch -r timestamp $file
done


%build
# Use -std=gnu17 to work around build issues with C23 that gcc 15 defaults to
%global optflags %optflags -std=gnu17

%configure
%make_build


%install
%makeinstall_std

# Remove the documentation here. We install it with %doc instead to
# the standard directory.
rm -f $RPM_BUILD_ROOT%{_datadir}/powwow/powwow.doc


%files
%doc --no-dereference COPYING
%doc ChangeLog doc/Config.demo doc/powwow.doc README
%{_datadir}/powwow/
%{_bindir}/*
%{_mandir}/man6/*

%files devel
%{_includedir}/powwow/


%changelog
