Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global opt %(test -x %{_bindir}/ocamlopt && echo 1 || echo 0)
%if !%{opt}
%global debug_package %{nil}
%endif

Name:           prooftree
Version:        0.13
Release:        alt3_17
Summary:        Proof tree visualization for Proof General

License:        GPLv3+
URL:            http://askra.de/software/prooftree/
Source0:        http://askra.de/software/prooftree/releases/%{name}-%{version}.tar.gz

BuildRequires:  ocaml ocaml-runtime
BuildRequires:  ocaml-findlib
BuildRequires:  ocaml-lablgtk-devel
BuildRequires:  ocaml-ocamldoc
Source44: import.info

%description
Prooftree is a program for proof-tree visualization during interactive
proof development in a theorem prover.  It is currently being developed
for Coq and Proof General.  Prooftree helps against getting lost between
different subgoals in interactive proof development.  It clearly shows
where the current subgoal comes from and thus helps in developing the
right plan for solving it.

Prooftree uses different colors for the already proven subgoals, the
current branch in the proof and the still open subgoals.  Sequent texts
are not displayed in the proof tree itself, but they are shown as a
tool-tip when the mouse rests over a sequent symbol.  Long proof
commands are abbreviated in the tree display, but show up in full length
as tool-tip.  Both, sequents and proof commands, can be shown in the
display below the tree (on single click) or in a separate window (on
double or shift-click).

Prooftree can mark the proof command that introduced a certain
existential variable and thus help to locate the problem when Coq says:
No more subgoals but non-instantiated existential variables.

%prep
%setup -q


# Preserve timestamps when installing
sed -i 's/cp /cp -p /' Makefile.in

%build
# Not an autoconf-generated script.  Do not use %%configure.
./configure --prefix %{_prefix}
%make_build

%install
%makeinstall_std

%files
%doc --no-dereference COPYING
%doc ChangeLog README
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*

%changelog
