# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ libICE-devel libSM-devel libX11-devel libncurses-devel
# END SourceDeps(oneline)
Summary:        Advanced Linux download manager
Name:           prozilla
Version:        2.0.4
Release:        alt1_18

License:        GPLv2+
Group:          Networking/WWW
Source0:        http://prozilla.genesys.ro/downloads/prozilla/tarballs/%{name}-%{version}.tar.bz2
Patch0:         prozilla1.patch
URL:            http://prozilla.genesys.ro/
BuildRequires:  ncurses-devel gettext
Source44: import.info


%description
ProZilla is a download accellerator program written for Linux to speed
up the normal file download process. It often gives speed increases of
around 200% to 300%. It supports both FTP and HTTP protocols, and the
theory behind it is very simple.

The program opens multiple connections to a server, and each of the
connections downloads a part of the file, thus defeating existing
internet congestion prevention methods which slow down a single
connection based download.

ProZilla also supports file download resuming, and ftpsearch for
fastest ping times.



%package devel
Summary: Development libraries and headers for prozilla
Group: Development/C
Requires: %{name} = %{version}


%description devel
The developmental files that must be installed in order to compile
applications which use prozilla.

%prep
%setup -q

# fix for makeinstall macro
sed -i -e \
     s'|gnulocaledir = $(prefix)/share/locale|gnulocaledir = ${RPM_BUILD_ROOT}$(prefix)/share/locale|' \
     po/Makefile.in.in

sed -i -e \
     s'|gnulocaledir = $(prefix)/share/locale|gnulocaledir = ${RPM_BUILD_ROOT}$(prefix)/share/locale|' \
     libprozilla/po/Makefile.in.in

%patch0 -p1
%configure

%build
CFLAGS="$RPM_OPT_FLAGS"
export CFLAGS

make %{?_smp_mflags}

%install

make DESTDIR=${RPM_BUILD_ROOT} INSTALL="install -p" install


rm -f ${RPM_BUILD_ROOT}%{_libdir}/libprozilla.la
rm -f ${RPM_BUILD_ROOT}%{_libdir}/libprozilla.a



rm -f ${RPM_BUILD_ROOT}%{_datadir}/locale/locale.alias ||:


%find_lang proz

%files -f proz.lang
%doc AUTHORS ChangeLog COPYING CREDITS* NEWS README TODO
%doc libprozilla/docs/HACKING docs/FAQ
%{_bindir}/proz
%{_mandir}/man1/proz*
# from libprozilla
%{_datadir}/locale/it/LC_MESSAGES/.mo
%{_datadir}/locale/nl/LC_MESSAGES/.mo
%{_datadir}/locale/pt_BR/LC_MESSAGES/.mo
%{_datadir}/locale/ro/LC_MESSAGES/.mo


%files devel
%{_includedir}/prozilla/



%changelog
