Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-alternatives rpm-macros-fedora-compat rpm-macros-generic-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global deb_ver 1.9.0+git20200626+067950b-2

Name:            pseudo
Version:         1.9.0
Release:         alt2_19.20210205gitf332f56
Summary:         Advanced tool for simulating superuser privileges

License:         GPLv3+ and LGPLv2+
URL:             https://www.yoctoproject.org/software-item/pseudo/
Source0:         https://downloads.yoctoproject.org/releases/pseudo/pseudo-%{version}.tar.bz2
Source1:         http://http.debian.net/debian/pool/main/p/pseudo/pseudo_%{deb_ver}.debian.tar.xz

# update to current master HEAD (060058b)
Patch0:          pseudo-1.9.0-060058b.patch
# update to current oe-core HEAD (f332f56)
Patch1:          pseudo-060058b-f332f56.patch
# Fix build with latest libattr
Patch10:         pseudo-1.9.0-attr.patch
# Fix some GCC warnings
Patch11:         pseudo-1.9.0-warnings.patch

Patch12:         pseudo-configure-c99.patch


BuildRequires:   acl
BuildRequires:   attr
BuildRequires:   gcc
BuildRequires:   libattr-devel
BuildRequires:   python3
BuildRequires:   rpm-build-python3
BuildRequires:   libsqlite3-devel

%global __provides_exclude_from ^(%{_libdir}/pseudo/.*\\.so)$
Source44: import.info

%description
The pseudo utility offers a way to run commands in a virtualized "root"
environment, allowing ordinary users to run commands which give the illusion of
creating device nodes, changing file ownership, and otherwise doing things
necessary for creating distribution packages or filesystems.

Pseudo has a lot of similarities to fakeroot but is a new implementation that
improves on the problems seen using fakeroot. Pseudo is now extensively used by
Poky as a replacement to fakeroot but can also be used standalone in many other
use cases.

%prep
%setup -q -a1
%patch0 -p1
%patch1 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1

sed -e 's,@LIBDIR@,%{_libdir}/pseudo,g' debian/fakeroot-pseudo.in > debian/fakeroot-pseudo
# tclsh is not available in Fedora
rm test/test-tclsh-fork.sh

%build
# custom configure script

./configure                  \
  --bits=%{__isa_bits}       \
  --cflags="$CFLAGS"         \
  --enable-memory-db         \
  --enable-xattr             \
  --enable-xattrdb           \
  --libdir=%{_libdir}/pseudo \
  --prefix=%{_prefix}        \
  --without-rpath
%make_build

%install
%makeinstall_std
install -Dpm0755 debian/fakeroot-pseudo %{buildroot}%{_bindir}
install -Dpm0644 debian/fakeroot-pseudo.1 %{buildroot}%{_mandir}/man1/fakeroot-pseudo.1
install -Dpm0644 pseudo.1 %{buildroot}%{_mandir}/man1/pseudo.1
install -Dpm0644 pseudolog.1 %{buildroot}%{_mandir}/man1/pseudolog.1
# For alternatives support
touch %{buildroot}%{_bindir}/fakeroot %{buildroot}%{_mandir}/man1/fakeroot.1
for rpm404_ghost in %{_bindir}/fakeroot %{_mandir}/man1/fakeroot.1*
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done
install -d $RPM_BUILD_ROOT/%_altdir; cat >$RPM_BUILD_ROOT/%_altdir/fakeroot_pseudo<<EOF
%{_bindir}/fakeroot	%{_bindir}/fakeroot-pseudo	5
%{_mandir}/man1/fakeroot.1.gz	%{_mandir}/man1/fakeroot-pseudo.1.gz	%{_bindir}/fakeroot-pseudo
EOF


%check
%make_build test

%files
%_altdir/fakeroot_pseudo
%doc --no-dereference COPYING
%doc ChangeLog.txt Futures.txt README
%{_bindir}/fakeroot-pseudo
%{_bindir}/pseudo
%{_bindir}/pseudodb
%{_bindir}/pseudolog
%{_libdir}/pseudo
%{_mandir}/man1/fakeroot-pseudo.1*
%{_mandir}/man1/pseudo.1*
%{_mandir}/man1/pseudolog.1*

%changelog
