Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: perl(HTTP/Request/Common.pm) perl(HTTP/Status.pm)
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Warning:
# Anyone editing this spec file please make sure the same spec file
# works on other fedora and epel releases, which are supported by this software.
# No quick Rawhide-only fixes will be allowed.

%global etcfiles disablesid.conf dropsid.conf enablesid.conf modifysid.conf pulledpork.conf

Summary:	Pulled Pork for Snort and Suricata rule management
Name:		pulledpork
Version:	0.7.4
Release:	alt2_14
# contrib/oink-conv.pl is GPLv2+
# Automatically converted from old format: GPLv2+ - review is highly recommended.
License:	GPL-2.0-or-later
URL:		https://github.com/shirkdog/pulledpork
Source0:	https://github.com/shirkdog/pulledpork/archive/v%{version}.tar.gz#/%{name}-%{version}.tar.gz
# Prepare pulledpork.conf for Fedora/EPEL
# sed -i 's#/usr/local/etc#/etc#g' pulledpork.conf
# sed -i 's#/usr/local/lib#/usr/lib64#g' pulledpork.conf
# sed -i 's#snort_path=/usr/local/bin#snort_path=/sbin#' pulledpork.conf
# sed -i 's#snort_control=/usr/local/bin#snort_control=/bin#' pulledpork.conf
# sed -i '/rule_url.*<oinkcode>/s/^/#/' pulledpork.conf
# sed -i '/sid=/s/^# //' pulledpork.conf
# sed -i 's#sid=/etc/snort#sid=/etc/pulledpork#' pulledpork.conf
# sed -i 's#distro=.*#distro=Centos-8#' pulledpork.conf
Source1:	%{name}.conf
BuildArch:	noarch

BuildRequires:	rpm-build-perl
%if 0%{?fedora}
BuildRequires:	perl-devel
%else
BuildRequires:	perl
%endif

# Used by pulledpork to download rules, without it one gets errors like
# Error 501 when fetching https://snort.org/downloads/community/community-rules.tar.gz.md5
# https://github.com/shirkdog/pulledpork/issues/221
BuildRequires:	perl(LWP/Protocol/https.pm)
Requires:	perl(LWP/Protocol/https.pm)
# Other dependencies
BuildRequires:	perl(LWP/UserAgent.pm)
Requires:	perl(LWP/UserAgent.pm)
BuildRequires:	perl(Sys/Syslog.pm)
Requires:	perl(Sys/Syslog.pm)
BuildRequires:	perl(Archive/Tar.pm)
Requires:	perl(Archive/Tar.pm)
BuildRequires:	perl(File/Copy.pm)
Requires:	perl(File/Copy.pm)

# handle license on el{6,7}: global must be defined after the License field above
%{!?_licensedir: %global license %doc}
Source44: import.info


%description
Pulled Pork for Snort and Suricata rule management (from Google code).


%prep
%setup -q -n %{name}-%{version}



%build


%install
install -d -m 0755 $RPM_BUILD_ROOT/%{_bindir}
install -d -m 0755 $RPM_BUILD_ROOT/%{_datadir}/%{name}
install -d -m 0755 $RPM_BUILD_ROOT/%{_sysconfdir}/%{name}

install -m 0755 %{name}.pl $RPM_BUILD_ROOT/%{_bindir}/%{name}
sed -i 's|#!/usr/bin/env perl|#!/usr/bin/perl -w|' $RPM_BUILD_ROOT/%{_bindir}/%{name}

cp -rp contrib $RPM_BUILD_ROOT/%{_datadir}/%{name}
chmod 0755 $RPM_BUILD_ROOT/%{_datadir}/%{name}/contrib/oink-conv.pl

cd etc
rm -f pulledpork.conf
cp %{SOURCE1} .
for file in disablesid.conf dropsid.conf enablesid.conf modifysid.conf pulledpork.conf; do
    install -m 0664 $file $RPM_BUILD_ROOT/%{_sysconfdir}/%{name}
done


%check
./pulledpork.pl -V


%files
%{_bindir}/%{name}
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/contrib
%{_datadir}/%{name}/contrib/oink-conv.pl
%{_datadir}/%{name}/contrib/README.CONTRIB
%dir %{_sysconfdir}/%{name}
%config(noreplace) %{_sysconfdir}/%{name}/disablesid.conf
%config(noreplace) %{_sysconfdir}/%{name}/dropsid.conf
%config(noreplace) %{_sysconfdir}/%{name}/enablesid.conf
%config(noreplace) %{_sysconfdir}/%{name}/modifysid.conf
%config(noreplace) %{_sysconfdir}/%{name}/pulledpork.conf
%doc README.md doc/README.CATEGORIES doc/README.CHANGES doc/README.RULESET doc/README.SHAREDOBJECTS
%doc --no-dereference LICENSE


%changelog
