Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: texinfo
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           pwmd
Version:        3.0.18
Release:        alt1_11
Summary:        A server for storing application data at a central location

License:        GPLv2+
URL:            http://bjk.sourceforge.net/pwmd/
Source0:        http://downloads.sourceforge.net/project/%{name}/%{version}/%{name}-%{version}.tar.bz2

BuildRequires:  gcc
BuildRequires:  cracklib-devel
Buildrequires:  glib2-devel libgio libgio-devel
Buildrequires:  libgnutls-devel libgnutlsxx-devel
BuildRequires:  libacl-devel
BuildRequires:  libassuan-devel >= 2.0.0
BuildRequires:  gcrypt-utils libgcrypt-devel
BuildRequires:  libgpg-error-devel
BuildRequires:  libubsan1
BuildRequires:  libxml2-devel
BuildRequires:  zlib-devel

Requires:       pinentry-common >= 0.7.5
Source44: import.info

%description
Password Manager Daemon is a server that provides a way for applications
to securely store and retrieve data at a centralized location. The data is
stored in an (optionally AES256 encrypted) XML file and clients connect and
send commands to manipulate the data. Some of the features include:

* Multi-threaded. More than one client may access the data at the same
  time.
* A key cache so clients won't need to enter a key each time a file is
  opened or saved.
* Key retrieval via pinentry(1).
* Configuration file which supports file specific settings including:
  encryption iterations, cache expiration and encryption key or key file
  and more.
* Compressed data file support.
* Logging to file and/or syslog.
* Secure memory usage. PWMD will zero out memory before freeing it and
  also has the option to lock the entire process in RAM to avoid swapping
  the data to virtual memory.

%prep
%setup -q

%build
%configure \
    --disable-static \
    --enable-gnutls \
    --enable-agent \
    --enable-quality \
    --enable-acl
%make_build

%install
make install DESTDIR=%{buildroot} INSTALL="install -p"
rm -f %{buildroot}%{_infodir}/dir

%check
make check

%files
%doc ChangeLog NEWS README doc/config.example
%doc --no-dereference COPYING
%{_mandir}/man*/%{name}*.*
%{_infodir}/%{name}.info.*
%{_bindir}/%{name}

%changelog
