Group: Development/Python
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
%define oldname python-mmtf
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 7

%bcond_without check
%global pname mmtf-python

%global desc \
The Macromolecular Transmission Format (MMTF) is a new compact binary format to\
transmit and store biomolecular structures for fast 3D visualization and\
analysis.\
\
Bradley AR, Rose AS, Pavelka A, Valasatava Y, Duarte JM, PrliA. A, Rose PW (2017)\
MMTF - an efficient file format for the transmission, visualization, and\
analysis of macromolecular structures. bioRxiv 122689. doi: 10.1101/122689\
\
Valasatava Y, Bradley AR, Rose AS, Duarte JM, PrliA. A, Rose PW (2017) Towards an\
efficient compression of 3D coordinates of macromolecular structures. PLOS ONE\
12(3): e0174846. doi: 10.1371/journal.pone.01748464\
\
Rose AS, Bradley AR, Valasatava Y, Duarte JM, PrliA. A, Rose PW (2016) Web-based\
molecular graphics for large complexes. In Proceedings of the 21st International\
Conference on Web3D Technology (Web3D '16). ACM, New York, NY, USA, 185-186.\
doi: 10.1145/2945292.2945324\


Name: python-module-mmtf
Version: 1.1.3
Release: alt1_%autorelease
Summary: A decoding library for the macromolecular transmission format (MMTF) 
License: Apache-2.0
URL: https://github.com/rcsb/mmtf-python
Source0: https://files.pythonhosted.org/packages/source/m/%{pname}/%{pname}-%{version}.tar.gz
BuildArch: noarch
Source44: import.info

%description
%{desc}

%package -n python3-module-mmtf
Group: Development/Python
Summary: %{summary}
BuildRequires: python3-devel
BuildRequires: python3-module-pkg_resources python3-module-setuptools
%if %{with check}
BuildRequires: python3-module-msgpack
BuildRequires: pytest3 python3-module-pytest
BuildRequires: python3-module-numpy python3-module-numpy-testing
%endif
%{?python_provide:%python_provide python3-mmtf}
Requires: python3-module-msgpack

%description -n python3-module-mmtf
%{desc}

%prep
%setup -q -n %{pname}-%{version}

%build
%python3_build

%install
%python3_install

%if %{with check}
%check
py.test-3 mmtf/tests/codec_tests.py
%endif

%files -n python3-module-mmtf
%doc --no-dereference LICENSE.txt
%doc CHANGELOG.md README.md
%{python3_sitelibdir_noarch}/mmtf_python-%{version}-py%{__python3_version}.egg-info
%{python3_sitelibdir_noarch}/mmtf

%changelog
