Group: Development/Python
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
%define oldname python-sqlacodegen
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%{?python_enable_dependency_generator}

%global modname sqlacodegen

Name:           python-module-sqlacodegen
Version:        2.0.0
Release:        alt2_26
Summary:        Automatic model code generator for SQLAlchemy

License:        MIT
URL:            https://github.com/agronholm/sqlacodegen
Source0:        https://files.pythonhosted.org/packages/source/%(n=%{modname}; echo ${n:0:1})/%{modname}/%{modname}-%{version}.tar.gz

BuildArch:      noarch

%global _description\
This is a tool that reads the structure of an existing database and generates\
the appropriate SQLAlchemy model code, using the declarative style if possible.\
\
This tool was written as a replacement for sqlautocode, which was suffering\
from several issues (including, but not limited to, incompatibility with\
Python 3 and the latest SQLAlchemy version).\
\
Features:\
* Supports SQLAlchemy 0.8.x - 1.2.x\
* Produces declarative code that almost looks like it was hand written\
* Produces PEP 8 compliant code\
* Accurately determines relationships, including many-to-many, one-to-one\
* Automatically detects joined table inheritance\
* Excellent test coverage
Source44: import.info

%description 
%{_description}

%package -n python3-module-sqlacodegen
Group: Development/Python
Summary:        Automatic model code generator for SQLAlchemy
%{?python_provide:%python_provide python3-%{modname}}
BuildRequires:  python3-devel
BuildRequires:  python3-module-pkg_resources python3-module-setuptools
BuildRequires:  python3-module-setuptools_scm >= 1.7.0

%description -n python3-module-sqlacodegen 
%{_description}

Python 3 version.

%prep
%setup -q -n %{modname}-%{version}


%build
%python3_build

%install
%python3_install

#check
# Requires multiple DBs to be running

%files -n python3-module-sqlacodegen
%doc --no-dereference LICENSE
%doc README.rst CHANGES.rst
%{_bindir}/%{modname}
%{python3_sitelibdir_noarch}/%{modname}*

%changelog
