Group: Development/Python
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python rpm-build-python3
BuildRequires: python-devel python-module-setuptools python3-module-setuptools
# END SourceDeps(oneline)
%define oldname python-stomper
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define fontpkgname python-stomper
%{?python_enable_dependency_generator}
# Disable Python 2
%bcond_with python2
# Enable Python 3
%bcond_without python3

%global commit 9b9fddf596a77e6b7e0407f0e45d02ca3a5ba5e1
%global shortcommit %(c=%{commit}; echo ${c:0:7})

Name:           python-module-stomper
Version:        0.4.3
Release:        alt2_11
Summary:        A python client implementation of the STOMP protocol
License:        ASL 2.0
URL:            https://pypi.io/project/stomper

Source0:        https://pypi.io/packages/source/s/stomper/stomper-%{version}.tar.gz

BuildArch:      noarch
Source44: import.info

%description
This is a python client implementation of the STOMP protocol. The client is
attempting to be transport layer neutral. This module provides functions to
create and parse STOMP messages in a programatic fashion.

%if %{with python3}
%package -n python3-module-stomper
Group: Development/Python
Summary:        A python client implementation of the STOMP protocol
%{?python_provide:%python_provide python3-stomper}

BuildRequires:  python3-devel
BuildRequires:  python3-module-distribute
BuildRequires:  python3-module-nose

%description -n python3-module-stomper
This is a python client implementation of the STOMP protocol. The client is
attempting to be transport layer neutral. This module provides functions to
create and parse STOMP messages in a programatic fashion.
%endif

%prep
%setup -q -n stomper-%{version}

%build
%if %{with python2}
%python_build
%endif
%if %{with python3}
%python3_build
%endif

%install
%if %{with python2}
%python_install
%endif
%if %{with python3}
%python3_install
%endif

%check
%if %{with python2}
PYTHONPATH=. nosetests-%{__python_version} -q
%endif
%if %{with python3}
PYTHONPATH=. nosetests-%{__python3_version} -q
%endif

%if %{with python2}
%files -n python-module-stomper
%doc README.rst
%{python_sitelibdir_noarch}/stomper*
%endif

%if %{with python3}
%files -n python3-module-stomper
%doc README.rst
%{python3_sitelibdir_noarch}/stomper*
%endif

%changelog
