Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
# END SourceDeps(oneline)
%define oldname python-txamqp
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global upstream_name txamqp

Name:           python-module-txamqp
Version:        0.8.1
Release:        alt1_12
Summary:        A Python library for communicating with AMQP peers and brokers using Twisted

License:        ASL 2.0
URL:            https://github.com/txamqp/txamqp
Source0:        https://files.pythonhosted.org/packages/source/t/txAMQP/txAMQP-%{version}.tar.gz

BuildArch:      noarch
BuildRequires:  python3-devel
BuildRequires:  python3-module-distribute

%global _description\
txAMQP is a Python library for communicating with AMQP peers and brokers using\
Twisted.\
\
This project contains all the necessary code to connect, send and receive\
messages to/from an AMQP-compliant peer or broker (Qpid, OpenAMQ, RabbitMQ)\
using Twisted.
Source44: import.info

%description 
%_description

%package -n python3-module-txamqp
Group: Development/Other
Summary:        Python 3 library for communicating with AMQP peers and brokers using Twisted
Requires:       python3-module-twisted-conch python3-module-twisted-core python3-module-twisted-conch python3-module-twisted-conch-gui python3-module-twisted-core python3-module-twisted-core-gui-wx python3-module-twisted-core-test python3-module-twisted-logger python3-module-twisted-mail python3-module-twisted-names python3-module-twisted-pair python3-module-twisted-positioning python3-module-twisted-runner python3-module-twisted-web python3-module-twisted-words
Requires:       amqp
%{?python_provide:%python_provide python3-%{upstream_name}}

%description -n python3-module-txamqp 
%_description

# Currently missing python3-thrift: https://bugzilla.redhat.com/show_bug.cgi?id=1533306
%if 0
%package -n python3-module-txamqp-thrift
Group: Development/Other
Summary:        Contributed Thrift libraries for Twisted (Python 3)
Requires:       python3-module-%{upstream_name} = %{version}-%{release}
Requires:       python3-module-thrift
%{?python_provide:%python_provide python3-%{upstream_name}-thrift}

%description -n python3-module-txamqp-thrift
txAMQP also includes support for using Thrift RPC over AMQP in Twisted
applications.
%endif

%prep
%setup -q -n txAMQP-%{version}
# Fix non-executable-script error
sed -i '/^#!\/usr\/bin\/env python/,+1 d' src/txamqp/codec.py

%build
%python3_build

%install
%python3_install

%files -n python3-module-txamqp
%doc LICENSE
%{python3_sitelibdir_noarch}/%{upstream_name}
%exclude %{python3_sitelibdir_noarch}/%{upstream_name}/contrib/thrift
%{python3_sitelibdir_noarch}/txAMQP-%{version}-*.egg-info

%if 0
%files -n python3-module-txamqp-thrift
%{python3_sitelibdir_noarch}/%{upstream_name}/contrib/thrift
%endif

%changelog
