Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: /usr/bin/trial-3
# END SourceDeps(oneline)
%define oldname python-txws
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# what it's called on pypi
%global srcname txWS
# what it's imported as
%global libname txws
# name of egg info directory
%global eggname %{srcname}
# package name fragment
%global pkgname %{libname}

%bcond_without tests

Name:             python-module-txws
Version:          0.9.1
Release:          alt1_38
Summary:          Twisted WebSockets wrapper

License:          MIT
URL:              https://github.com/MostAwesomeDude/txWS
# PyPI tarball doesn't have tests
Source0:          https://github.com/MostAwesomeDude/txWS/archive/%{version}/%{srcname}-%{version}.tar.gz

# Downstream-only patch.  Make sure to update when the version changes!
Patch0:           0001-Drop-vcversioner.patch

# https://github.com/MostAwesomeDude/txWS/pull/34
Patch1:           python-txws-python39.patch

BuildArch:        noarch

%global common_description \
txWS (pronounced "Twisted WebSockets") is a small, short, simple library\
for adding WebSockets server support to your favorite Twisted applications.
Source44: import.info

%description 
%{common_description}

%package -n python3-module-txws
Group: Development/Other
Summary:          %{summary}
BuildRequires:    python3-devel
BuildRequires:    python3-module-pkg_resources python3-module-setuptools
%if %{with tests}
BuildRequires:    python3-module-twisted-conch python3-module-twisted-conch-gui python3-module-twisted-core python3-module-twisted-core-gui-gnome python3-module-twisted-core-gui-tk python3-module-twisted-core-gui-wx python3-module-twisted-logger python3-module-twisted-mail python3-module-twisted-names python3-module-twisted-pair python3-module-twisted-positioning python3-module-twisted-runner python3-module-twisted-web python3-module-twisted-words twisted-core-tools python3-module-six
%endif
%{?python_provide:%python_provide python3-%{pkgname}}

%description -n python3-module-txws 
%{common_description}

%prep
%setup -q -n %{srcname}-%{version}
%patch0 -p1
%patch1 -p1

rm -rf %{eggname}.egg-info

%build
%python3_build

%install
%python3_install

%check
%if %{with tests}
PYTHONPATH=$(pwd) trial-3 tests
%endif

%files -n python3-module-txws
%doc --no-dereference LICENSE
%doc README.rst
%{python3_sitelibdir_noarch}/%{libname}.py
%{python3_sitelibdir_noarch}/__pycache__/%{libname}.cpython-3*.py*
%{python3_sitelibdir_noarch}/%{eggname}-%{version}-py%{__python3_version}.egg-info


%changelog
