Group: Engineering
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		qbrew
Version:	0.4.1
Release:	alt2_34
Summary:	A Brewing Recipe Calculator

License:	BSD
URL:		http://www.usermode.org/code.html
Source0:	http://www.usermode.org/code/%name-%{version}.tar.gz
Patch0:		qbrew-fix-return-type.patch
BuildRequires:	libqt4-declarative libqt4-devel libqt4-help qt4-designer qt4-doc-html qt5-declarative-devel qt5-designer qt5-tools, desktop-file-utils
Source44: import.info

%description
QBrew is a homebrewer's recipe calculator. You can create and modify
ale and lager recipes as well as calculate gravity, color, and
bitterness. QBrew includes a database of styles, grains, hops, and
miscellaneous ingredients, plus a brewing tutorial.

%prep
%setup -q
find src -type f -exec chmod 0644 {} \;
%patch0 -p1

%build
# qbrew expects the docs to be %{_prefix}/share/doc/qbrew,
# NOT .../doc/qbrew-%{version}
echo "QMAKE_CFLAGS_RELEASE=\"%{optflags}\"" >> qbrew.pro
echo "QMAKE_CXXFLAGS_RELEASE=\"%{optflags}\"" >> qbrew.pro
echo "QMAKE_LFLAGS_RELEASE=\"%{optflags}\"" >> qbrew.pro

%{_configure_script} --prefix=%{_prefix} \
	      --bindir=%{_bindir} \
	      --datadir=%{_datadir}/%{name} \
	      --docdir=%{_defaultdocdir}/%{name}
make %{?_smp_mflags}

(
cat <<EODESKTOP
[Desktop Entry]
Name=Qbrew
GenericName=Qbrew
Comment=%{summary}
Exec=qbrew
Icon=qbrew
Terminal=false
Type=Application
Categories=Amusement;
EODESKTOP
) > %{name}.desktop

# create translation files
for ts in translations/*.ts; do
    %{_qt4_bindir}/lrelease ${ts}
done

%install
make install INSTALL_ROOT=${RPM_BUILD_ROOT}

mkdir -p ${RPM_BUILD_ROOT}%{_datadir}/pixmaps
cp pics/%{name}.png ${RPM_BUILD_ROOT}%{_datadir}/pixmaps

mkdir -p ${RPM_BUILD_ROOT}%{_datadir}/applications
desktop-file-install \
   --dir=${RPM_BUILD_ROOT}%{_datadir}/applications \
   %{name}.desktop

mkdir -p ${RPM_BUILD_ROOT}%{_datarootdir}/%{name}/translations
cp translations/*.ts translations/*.qm \
   ${RPM_BUILD_ROOT}%{_datarootdir}/%{name}/translations


%files
%{_bindir}/*
%{_datadir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/%{name}.png
%{_datarootdir}/%{name}
%{_defaultdocdir}/%{name}

%doc AUTHORS ChangeLog TODO *.qbrew LICENSE README

%changelog
