Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           qcommandline
Version:        0.3.0
Release:        alt2_27
Summary:        Command line parser for Qt programs
License:        LGPLv2+
URL:            http://xf.iksaif.net/dev/qcommandline.html
Source0:        http://xf.iksaif.net/dev/qcommandline/qcommandline-%{version}.tar.bz2
# http://dev.iksaif.net/issues/253
Patch1:         0001-fix-pkg-config-paths.patch
# http://dev.iksaif.net/issues/252 -- enhancements for PhantomJS
Patch2:         0002-new-ParameterFence-flag.patch
Patch3:         0003-new-NoShortName-flag-to-allow-options-with-no-short-.patch
Patch4:         0004-new-SuppressHelp-flag.patch
# https://gitorious.org/qcommandline/qcommandline/merge_requests/3
Patch5:         0005-qt5.patch
BuildRequires:  ctest cmake
BuildRequires:  libqt4-declarative libqt4-devel libqt4-help qt4-designer qt4-doc-html qt5-declarative-devel qt5-designer qt5-tools
BuildRequires:  qt5-base-devel
Source44: import.info

%description
QCommandLine is a command line parsing library for Qt programs (like getopt). 
Features include options, switches, parameters and automatic --version/--help 
generation.

%package devel
Group: Other
Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}
Requires:       pkgconfig
Requires:       ctest cmake

%description devel
Development files for building against %{name}.

%package qt5
Group: Other
Summary:        Command line parser for Qt5 programs

%description qt5
QCommandLine is a command line parsing library for Qt5 programs (like getopt). 
Features include options, switches, parameters and automatic --version/--help 
generation.

%package qt5-devel
Group: Other
Summary:        Development files for %{name}-qt5
Requires:       %{name}-qt5 = %{version}-%{release}
Requires:       pkgconfig
Requires:       ctest cmake

%description qt5-devel
Development files for building against %{name}.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

%global qt5dir %{_builddir}/qt5-%{name}-%{version}
rm -rf %{qt5dir}
cp -a . %{qt5dir}
cd %{qt5dir}
%patch5 -p1
# rename the library to libqcommandline-qt5 to distinguish it from the Qt4 build
echo "set_target_properties(qcommandline PROPERTIES OUTPUT_NAME qcommandline-qt5)" >>CMakeLists.txt
sed -i -e 's/-lqcommandline/-lqcommandline-qt5/' QCommandLine.pc.in
sed -i -e 's/QCommandLine\.pc$/QCommandLine-qt5.pc/' CMakeLists.txt

%build
%{fedora_v2_cmake} -DCMAKE_MODULES_INSTALL_DIR=%{_datadir}/cmake/Modules
%fedora_v2_cmake_build

cd %{qt5dir}
%{fedora_v2_cmake} -DCMAKE_MODULES_INSTALL_DIR=%{_datadir}/cmake/Modules
%fedora_v2_cmake_build

%install
%fedora_v2_cmake_install

cd %{qt5dir}
%fedora_v2_cmake_install

%files
%doc COPYING
%{_libdir}/lib%{name}.so.*

%files qt5
%doc COPYING
%{_libdir}/lib%{name}-qt5.so.*

%files devel
%doc examples/
%{_libdir}/lib%{name}.so
%{_includedir}/%{name}
%{_libdir}/pkgconfig/QCommandLine.pc
%{_datadir}/cmake/Modules/FindQCommandLine.cmake

%files qt5-devel
%{_libdir}/lib%{name}-qt5.so
%{_includedir}/%{name}
%{_libdir}/pkgconfig/QCommandLine-qt5.pc
%{_datadir}/cmake/Modules/FindQCommandLine.cmake





%changelog
