# BEGIN SourceDeps(oneline):
BuildRequires: perl(Gtk2.pm) perl(Gtk2/GladeXML.pm) perl(IO/File.pm) perl(Locale/gettext.pm) perl(encoding.pm)
# END SourceDeps(oneline)
%define fedora 19
Name:      qemu-launcher
Version:   1.7.4
Release:   alt1_13
Summary:   A graphical front-end to Qemu virtual machines

Group:     Emulators
License:   GPLv2+
URL:       https://gna.org/projects/qemulaunch/

Source0:   http://download.gna.org/qemulaunch/1.7.x/%{name}_%{version}.tar.gz
#Patch0 changes:
# qemu-launcher.desktop: Removed file extension from Icon, changed Categories
#   to System
# Makefile: "install" commands given -p switch to preserve timestamps
Patch0:    %{name}-%{version}.patch
BuildArch: noarch
ExcludeArch: ppc64

BuildRequires: desktop-file-utils
BuildRequires: gettext
BuildRequires: libxml2
Requires:      qemu
Requires:      perl-Gtk2-GladeXML
Requires:      perl-Locale-gettext
Source44: import.info

%description
Qemu Launcher provides a graphical front-end to all basic, and many advanced
QEMU computer emulator options. It allows you to create, save, and run multiple
virtual machine configurations, create and convert disk images.

%prep
%setup -q
%patch0 -p1


%build
make PREFIX=%{_prefix} %{?_smp_mflags}


%install
make install                                 \
  PREFIX=%{_prefix} DESTDIR=%{buildroot}     \
  DOCSDIR="." #Install docs in cwd, and catch them with %doc below
desktop-file-install \
%if 0%{?fedora}  && 0%{?fedora} < 19
  --vendor fedora \
%endif
  --delete-original  \
  --dir %{buildroot}/%{_datadir}/applications/          \
  %{buildroot}/%{_datadir}/applications/%{name}.desktop
%find_lang %{name}


%files -f %{name}.lang
%doc Changelog COPYING README TODO
%{_bindir}/*
%{_datadir}/%{name}
%{_datadir}/applications/*
%{_datadir}/pixmaps/*
%{_datadir}/icons/hicolor/*/apps/*
%{_mandir}/man1/*


%changelog
