Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 42

# Upstream uses weird versioning convention
%global upstreamver 2.3_1-opensource

Summary:    QIODevice that compresses data streams
Name:       qtiocompressor
Version:    2.3.1
Release:    alt2_%autorelease
License:    GPLv3 or LGPLv2 with exceptions
URL:        http://qt.nokia.com/products/appdev/add-on-products/catalog/4/Utilities/qtiocompressor/

Source0:    https://fale.fedorapeople.org/qtiocompressor/qtiocompressor-%{upstreamver}.tar.gz
Source1:    qtiocompressor.prf
Patch0:     qtiocompressor-qt6.patch

BuildRequires: qt5-base-devel qt6-base-devel
BuildRequires: zlib-devel
Source44: import.info

%description
The class works on top of a QIODevice subclass, compressing data before it is
written and decompressing it when it is read. Since QtIOCompressor works on
streams, it does not have to see the entire data set before compressing or
decompressing it. This can reduce the memory requirements when working on large
data sets.

%package devel
Group: Development/Other
Summary:    Development files for %{name}
Requires:   %{name} = %{version}-%{release}

%description devel
This package contains libraries and header files for developing applications
that use QtIOCompressor.

%prep
%setup -q -n %{name}-%{upstreamver}
%patch0 -p1


# Drop 'examples' from SUBDIRS to avoid build errors due to missing -lz
sed -i '/SUBDIRS.*examples/d' qtiocompressor.pro

%build
touch .licenseAccepted
./configure -library
%qmake_qt6
%make_build

%install
# libraries
mkdir -p %{buildroot}%{_qt6_libdir}
cp -a lib/* %{buildroot}%{_qt6_libdir}
chmod 755 %{buildroot}%{_qt6_libdir}/*.so.*.*.*

# headers
mkdir -p %{buildroot}%{_qt6_headerdir}/QtSolutions
cp -a \
    src/qtiocompressor.h \
    src/QtIOCompressor \
    %{buildroot}%{_qt6_headerdir}/QtSolutions

# qmake support
mkdir -p %{buildroot}%{_qt6_libdir}/qt6/mkspecs/features/
cp -a %{SOURCE1} %{buildroot}%{_qt6_libdir}/qt6/mkspecs/features/

%files
%doc --no-dereference LGPL_EXCEPTION.txt LICENSE.*
%doc README.TXT
%{_qt6_libdir}/lib*.so.1*

%files devel
%doc doc
%{_qt6_libdir}/lib*.so
%{_qt6_headerdir}/QtSolutions/
%{_qt6_libdir}/qt6/mkspecs/features/%{name}.prf

%changelog
