# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ libGL-devel libX11-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           quesa
Version:        1.8
Release:        alt1_17
Summary:        Quesa QuickDraw 3D implementation

Group:          System/Libraries
License:        BSD
URL:            http://www.quesa.org/
Source0:        http://downloads.sourceforge.net/quesa/quesa-%{version}.tar.gz

BuildRequires:  libGLU-devel
BuildRequires:  autoconf automake libtool
#Requires:       

Patch0: quesa-1.8-excess-libs.patch
Patch1: quesa-1.8-cxx.patch
Source44: import.info

%description
Quesa is a high-level open-source 3D graphics library that offers binary and
source level compatibility with Apple's QuickDrawa.. 3D API. Quesa does not
contain any Apple source code, and was developed without access to Apple's
QD3D implementation.

Quesa supports both retained and immediate mode rendering, an extensible file
format, plug-in renderers, a wide range of high level geometries, hierarchical
models, and a consistent and object-oriented API.  Quesa acts as a scene-graph
while using OpenGL for rendering. 

%package devel
Summary: Quesa development package
Group: Development/Other
Requires: quesa = %{version}-%{release}

%description devel
Development package for the Quesa library.

%prep
%setup -q
%patch0 -p1 -b .excess-libs
%patch1 -p1 -b .cxx
find Source/FileFormats/ -name '*.[ch]' | xargs chmod a-x

%build
autoreconf -v --install || exit 1
%configure --disable-static
%make_build
iconv -f MACINTOSH -t UTF-8 AUTHORS > foo && mv foo AUTHORS

%install
make install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -name \*.la | xargs rm -f

%files
%doc AUTHORS COPYING README
%{_libdir}/libquesa.so.0*

%files devel
%{_includedir}/quesa
%{_libdir}/libquesa.so

%changelog
