Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       ramond
Version:    0.5
Release:    alt1_30
Summary:    Router advertisement monitoring daemon
# Automatically converted from old format: BSD - review is highly recommended.
License:    LicenseRef-Callaway-BSD
URL:        http://%{name}.sourceforge.net/
Source0:    http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.bz2
Source1:    %{name}.service
# Respect distribution compiler options
Patch0:     %{name}-0.5-Respect-CFLAGS-and-LDFLAGS.patch
# Fix compiler warnings
Patch1:     %{name}-0.5-Fix-compiler-warnings-about-unused-variables-and-imp.patch
# Fix compiler warnings
Patch2:     %{name}-0.5-Fix-warnings-about-incompatible-types.patch
# Fix compiler warnings, undefined behavior on glibc
Patch3:     %{name}-0.5-Do-not-unset-variables-by-setenv.patch
# Fix building with GCC 10
Patch4:     %{name}-0.5-Fix-building-with-GCC-10.patch
BuildRequires:  libapr1-devel
BuildRequires:  coreutils
BuildRequires:  gcc
BuildRequires:  libpcap-devel
BuildRequires:  libxml2-devel
BuildRequires:  sed
BuildRequires:  rpm-macros-systemd

# Do not find depenendecies in the documentation
%global __requires_exclude_from %{?__requires_exclude_from:%__requires_exclude_from|}^%{_datadir}/doc
Source44: import.info

%description
This program monitors IPv6 networks for router advertisements. When an
advertisement is received, a configurable action occurs.

%prep
%setup -q -n %{name}
%patch0  -p1
%patch1  -p1
%patch2  -p1
%patch3  -p1
%patch4  -p1

%build
%global _hardened_build 1
%make_build CFLAGS="$RPM_OPT_FLAGS" LDFLAGS="$RPM_LD_FLAGS"
sed -e '/All Routers Mac List/,/<\/ramond>/ c </ramond>' \
    <ramond.conf.example >ramond.conf

%install
install -d '%{buildroot}%{_sbindir}'
install -m 0755 -t '%{buildroot}%{_sbindir}' %{name}
install -d '%{buildroot}%{_sysconfdir}'
install -m 0644 -t '%{buildroot}%{_sysconfdir}' %{name}.conf
install -d '%{buildroot}%{_unitdir}'
install -m 0644 -t '%{buildroot}%{_unitdir}' '%{SOURCE1}'

%post
%post_service %{name}

%preun
%preun_service %{name}

%files
%doc --no-dereference LICENSE
%doc CHANGELOG README THANKS
%doc demo.pl ramond.conf.*
%config(noreplace) %{_sysconfdir}/%{name}.conf
%{_sbindir}/%{name}
%{_unitdir}/%{name}.service

%changelog
