Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install fontconfig-devel libXcursor-devel libXext-devel libXfixes-devel libXft-devel libXinerama-devel libXrender-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: rasterview
Summary: CUPS raster file viewer
Version: 1.7.1
Release: alt1_18
# Automatically converted from old format: GPLv2+ - review is highly recommended.
License: GPL-2.0-or-later
Source: https://www.msweet.org/files/project7/rasterview-%{version}.tar.gz
Url: http://www.msweet.org/projects.php/rasterview

BuildRequires:  gcc-c++
BuildRequires:  gcc
BuildRequires: libfltk-devel
BuildRequires: libcups-devel
BuildRequires: libpng-devel libpng17-tools
BuildRequires: libjpeg-devel
BuildRequires: zlib-devel
BuildRequires: desktop-file-utils >= 0.2.92

Patch1: rasterview-desktop-file.patch
Patch2: rasterview-fltk.patch
Source44: import.info

%description
CUPS uses an intermediate format called raster for inkjet printers and
others that require rasterized input.  This program can be used to
view this intermediate format and is mainly used for debugging printer
drivers.

%prep
%setup -q -c %{name}-%{version}

# Fixes for desktop file.
%patch1  -p1 -b .desktop-file

# Don't include static libraries for fltk
%patch2  -p1 -b .fltk

%build
%configure
make

%install
make BUILDROOT=%{buildroot} INSTALL='install -p' install

rm -rf %{buildroot}%{_sysconfdir}/X11/applnk
rm -f %{buildroot}%{_datadir}/applnk/Development/rasterview.desktop
desktop-file-install \
	--dir %{buildroot}%{_datadir}/applications \
	--add-category System \
	rasterview.desktop

%files
%doc README.md LICENSE NOTICE
%{_bindir}/rasterview
%{_datadir}/icons/hicolor/*/apps/rasterview.png
%{_datadir}/mimelnk/application/vnd.cups-raster.desktop
%{_datadir}/mimelnk/image/pwg-raster.desktop
%{_datadir}/mimelnk/image/urf.desktop
%{_datadir}/applications/*.desktop
%{_datadir}/applications/Development/rasterview.desktop

%changelog
