# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           ratproxy
Version:        1.58
Release:        alt2_17
Summary:        A passive web application security assessment tool
Group:          Networking/WWW
License:        ASL 2.0
URL:            http://code.google.com/p/%{name}/
# URL of actual source containing binary
# generate-tarball.sh removes that binary and makes source0 tarball.
Source0:        ratproxy-1.56-nobinary.tar.gz
Source1:        generate-tarball.sh
Patch0:        ratproxy-report-full-path-to-image.patch

BuildRequires:  gcc
BuildRequires:  libssl-devel
Source44: import.info

%description
A semi-automated, largely passive web application security audit tool,
optimized for an accurate and sensitive detection, and automatic
annotation, of potential problems and security-relevant design
patterns based on the observation of existing, user-initiated traffic
in complex web 2.0 environments.
             Detects and prioritizes broad classes of security
problems, such as dynamic cross-site trust model considerations,
script inclusion issues, content serving problems, insufficient XSRF
and XSS defenses, and much more.

%prep
%setup -q -n %{name}
%patch0

%build
sed -i -e 's@-O3@-O2@' Makefile
%make_build CFLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE -Wno-pointer-sign"

%install
mkdir -p $RPM_BUILD_ROOT%{_bindir}/
install -p %{name} $RPM_BUILD_ROOT/%{_bindir}/
install -p ratproxy-report.sh $RPM_BUILD_ROOT/%{_bindir}/ratproxy-report
install -Dp ratproxy-back.png $RPM_BUILD_ROOT/%{_datadir}/%{name}/images/ratproxy-back.png
rm doc/Solaris.README
chmod 644 doc/*

%files
%doc doc/*
%{_bindir}/%{name}
%{_bindir}/ratproxy-report
%{_datadir}/%{name}/*

%changelog
