Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global commit      10d00345a6824a250e93a20c974f9493281d69b4
%global file_name   de.haeckerfelix.Remotely

Name:           remotely
Version:        1.0
Release:        alt2_5
Summary:        Simple VNC viewer for the GNOME desktop environment

License:        GPLv3+
URL:            https://gitlab.gnome.org/World/Remotely
Source0:        %{url}/-/archive/v%{version}/%{name}-%{version}.tar.gz

BuildRequires:  desktop-file-utils
BuildRequires:  libappstream-glib
BuildRequires:  meson
BuildRequires:  vala vala-tools
BuildRequires:  pkgconfig(gtk+-3.0) >= 3.20.10
BuildRequires:  pkgconfig(gtk-vnc-2.0)

Requires:       icon-theme-hicolor
Source44: import.info

%description
Remotely is a simple VNC viewer for the GNOME desktop environment. It supports
common authentication methods. The display can be adjusted with three different
modes so that the most optimal presentation is always possible, regardless of
the remote display size.

%prep
%setup -q -n Remotely-v%{version}-%{commit}


%build
%meson
%meson_build

%install
%meson_install

%check
appstream-util validate-relax --nonet %{buildroot}%{_metainfodir}/%{file_name}.appdata.xml
desktop-file-validate %{buildroot}%{_datadir}/applications/%{file_name}.desktop

%files
%doc README.md
%doc --no-dereference COPYING
%{_bindir}/%{name}
%{_datadir}/applications/%{file_name}.desktop
%{_datadir}/glib-2.0/schemas/%{file_name}.gschema.xml
%{_datadir}/icons/hicolor/*/apps/*
%{_metainfodir}/%{file_name}.appdata.xml

%changelog
