Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           renameutils
Version:        0.12.0
Release:        alt2_30
Summary:        A set of programs to make renaming and copying of files easier

# Automatically converted from old format: GPLv3+ - review is highly recommended.
License:        GPL-3.0-or-later
URL:            http://www.nongnu.org/renameutils
Source0:        http://savannah.nongnu.org/download/%{name}/%{name}-%{version}.tar.gz
Patch0:         renameutils-0.12.0-install-typo.patch
# Based on patch from Debian. Also updates declarations.
# https://salsa.debian.org/debian/renameutils/-/blob/8d33a6d7ad3eafe997c8dcff5a17493e7f698a36/debian/patches/gcc15-fixes.patch
Patch1:         renameutils-0.12.0-gcc15-fixes.patch

BuildRequires:  gcc
BuildRequires:  autoconf
BuildRequires:  libreadline-devel
BuildRequires:  gettext-tools
# Bundled library exception: https://fedorahosted.org/fpc/ticket/174
Provides:       bundled(gnulib) = 20120423
Source44: import.info

%description
The file renaming utilities (renameutils for short) are a set of
programs designed to make renaming of files faster and less
cumbersome.

The file renaming utilities consists of five programs - qmv, qcp, imv,
icp and deurlname.

The qmv ("quick move") program allows file names to be edited in a
text editor. The names of all files in a directory are written to a
text file, which is then edited by the user. The text file is read and
parsed, and the changes are applied to the files.

The qcp ("quick cp") program works like qmv, but copies files instead
of moving them.

The imv ("interactive move") program, is trivial but useful when you
are too lazy to type (or even complete) the name of the file to rename
twice. It allows a file name to be edited in the terminal using the
GNU Readline library. icp copies files.

The deurlname program removes URL encoded characters (such as %%20
representing space) from file names. Some programs such as w3m tend to
keep those characters encoded in saved files.


%prep
%setup -q
%patch0  -p1 -b .install-typo
%patch1  -p1 -b .gcc15-fixes


%build
%configure
%make_build


%install
%makeinstall_std INSTALL="install -p"
%find_lang %{name}
%find_lang %{name}-gnulib
# multiple -f flags in %files for <main>: merging -f %{name}-gnulib.lang into -f %{name}.lang
cat %{name}-gnulib.lang >> %{name}.lang


%files -f %{name}.lang 
%doc README TODO COPYING NEWS AUTHORS
%{_bindir}/*
%{_mandir}/man1/*


%changelog
