# BEGIN SourceDeps(oneline):
BuildRequires: libdb4-devel libgpg-error-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       reprepro
Version:    5.4.1
Release:    alt1_1
Group:      System/Servers
Summary:    Tool to handle local repositories of Debian packages
# filecntl.c, md5.c, md5.h are Public Domain
# dpkgversions.c is GPLv2+
# docs/sftp.py is MIT
# Rest is GPLv2
License:    GPLv2 and GPLv2+ and MIT
URL:        http://mirrorer.alioth.debian.org/
# We use the Ubuntu URL here because upstream has not posted the latest release
# to alioth, and it's not clear if they will ever do so.
Source0:    https://deb.debian.org/debian/pool/main/r/reprepro/%{name}_%{version}.orig.tar.xz
BuildRequires: libdb5.3 libdb5.3-cxx libdb5.3-sql libdb5.3-tcl libdb5.3-tcl-devel
BuildRequires: pkgconfig(zlib)
BuildRequires: gpgme libgpgme-devel
BuildRequires: pkgconfig(bzip2)
BuildRequires: pkgconfig(libarchive)
BuildRequires: pkgconfig(liblzma)
Source44: import.info

%description
reprepro is a tool to manage a repository of Debian packages (.deb).  It
stores files either being injected manually or downloaded from some other
repository (partially) mirrored into one pool/ hierarchy.  Managed packages
and files are stored in a Berkeley DB, so no database server is needed.
Checking signatures of mirrored repositories and creating signatures of the
generated Package indexes is supported.

%prep
%setup -q

# files in docs should not have executable permissions
find docs -type f -exec chmod -x {} +

%build
autoreconf -vfi
%configure

%make_build

%install
%makeinstall_std

pushd docs

# Shell completion files
mkdir -p %{buildroot}%{_datadir}/bash-completion/completions
mv reprepro.bash_completion %{buildroot}%{_datadir}/bash-completion/completions/reprepro
mkdir -p %{buildroot}%{_datadir}/zsh/site-functions/
mv reprepro.zsh_completion %{buildroot}%{_datadir}/zsh/site-functions/_reprepro

rm Makefile{,.am,.in} changestool.1 rredtool.1 reprepro.1

# Note: Upstream sources contain tests/test.sh, but Fedora lacks some
# dependencies to run this.

%files
%doc --no-dereference COPYING
%doc docs/ AUTHORS README NEWS
%{_mandir}/man1/changestool.1*
%{_mandir}/man1/reprepro.1*
%{_mandir}/man1/rredtool.1*
%{_bindir}/changestool
%{_bindir}/reprepro
%{_bindir}/rredtool
%{_datadir}/bash-completion/completions/reprepro
%{_datadir}/zsh/site-functions/_reprepro


%changelog
