Group: Graphical desktop/Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install /usr/bin/glib-gettextize imake libXrandr-devel libXt-devel pkgconfig(gconf-2.0) pkgconfig(gtk+-2.0) xorg-cf-files
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	Resolution Switching Applet
Name:		resapplet
Version:	0.1.4
Release:	alt1_20
License:	GPLv2+ and GPLv2
# This is the best we have to silence rpmlint:
URL:		http://svn.gnome.org/viewcvs/resapplet/
# Source obtained from OpenSuSE
Source:		resapplet-%{version}.tar.bz2
Source1:	resapplet.desktop.in
Patch1:		resapplet-transparent-trayicon.patch
Patch2:		resapplet-susebug25115.patch
Patch3:		resapplet-rotate-wacom.patch
Patch4:		resapplet-0.1.1-link_X11.patch
Patch5:		resapplet-0.1.4-properties.patch
BuildRequires:  gcc
BuildRequires:	gnome-icon-theme libgnomeui-devel 
BuildRequires:	intltool, automake gettext gettext-tools, desktop-file-utils
Requires:	libgnomeui >= 2.2 libgail libgtk+2 
#Requires: gconf-editor >= 2.6 
Requires:	gnome-icon-theme
Source44: import.info

%description
Resapplet is a simple utility that sits in the system notification area
and allows switching the resolution and refresh rate.  It uses the
xrandr extensions to switch the resolution on-the-fly and user
resolution preferences to save the resolution.

It works in both GNOME and KDE, because it uses the system notification
area.

%prep
%setup -q 
cp -a %{S:1} . 
%patch1 -p0
%patch2 -p0
%patch3 -p1 -b .wacom
%patch4 -p1 -b .lX11
%patch5 -p1

%build
#glib-gettextize
aclocal
intltoolize --force
autoheader
automake --add-missing
autoconf
export CFLAGS="$RPM_OPT_FLAGS"

%configure	--datadir=%{_datadir} \
		--libdir=%{_libdir} \
		--localstatedir=%{_libdir} \
		--prefix=%{_prefix}
make


%install
make install DESTDIR=$RPM_BUILD_ROOT

desktop-file-install --delete-original		\
	--dir $RPM_BUILD_ROOT%{_datadir}/applications		\
	--add-category Utility					\
	--add-category X-Red-Hat-Base				\
	$RPM_BUILD_ROOT%{_datadir}/applications/resapplet.desktop

mkdir -p $RPM_BUILD_ROOT%{_datadir}/gnome/autostart/
# install autostart file
cp $RPM_BUILD_ROOT%{_datadir}/applications/resapplet.desktop $RPM_BUILD_ROOT%{_datadir}/gnome/autostart/
mv %buildroot/usr/locale %buildroot/usr/share/locale

%find_lang %name

%files -f %name.lang
%doc COPYING README
%{_bindir}/resapplet
%{_datadir}/applications/*resapplet.desktop
%{_datadir}/gnome/autostart/*resapplet.desktop
%{_datadir}/icons/hicolor/16x16/apps/resapplet.png
%{_datadir}/icons/hicolor/22x22/apps/resapplet.png
%{_datadir}/icons/hicolor/24x24/apps/resapplet.png
%{_datadir}/icons/hicolor/32x32/apps/resapplet.png
%{_datadir}/icons/hicolor/scalable/apps/resapplet.svg

%changelog
