Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: perl(FileHandle.pm) perl(XML/Parser/Expat.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           rnv
Version:        1.7.11
Release:        alt2_22
Summary:        Implementation of Relax NG Compact Syntax validator in ANSI C

License:        BSD
URL:            http://sourceforge.net/projects/rnv/
Source0:        http://downloads.sourceforge.net/project/rnv/Sources/%{version}/%{name}-%{version}.tar.xz
Source1:        arx.1
Source2:        xsdck.1
Source3:        rvp.1
Source4:        metainfo.xml
# Sent upstream via email
Patch0:    %{name}.system-paths-lookup.patch
# Adds docbook to arx.conf, because upstream version doesn't ship any useful schemas
Patch1:    %{name}.arx-conf-with-docbook.patch
Patch2:    %{name}.rvp-pl-wrong-interpreter.patch

BuildRequires:  libexpat-devel
BuildRequires:  gcc
BuildRequires:  autoconf
BuildRequires:  automake

Requires:       docbook5-schemas
Source44: import.info

%package -n vim-rnv
Group: Other
Summary:        Vim plugin for validating XML files against Relax NG Compact schemas using RNV

Requires:       xxd
Requires:       %{name} = %{version}-%{release}
BuildArch:      noarch

%description
RNV uses Relax NG compact syntax schemas to check if a given XML file is
valid in respect to the language defined by the Relax NG schema. RNV
uses Expat for XML parsing.

%description -n vim-rnv
Vim plugin providing redefined make command that validates
XML files against Relax NG schemas.

%prep
%setup -q
%patch0
%patch1
%patch2

cp -p %SOURCE1 .
cp -p %SOURCE2 .
cp -p %SOURCE3 .

%build
autoreconf -i
%configure --enable-dxl
%make_build

%install
%makeinstall_std

mkdir -p %{buildroot}%{_datadir}/appdata
install -m644 %SOURCE4 %{buildroot}%{_datadir}/appdata/vim-rnv.metainfo.xml

%files
%{_bindir}/rnv
%{_bindir}/arx
%{_bindir}/xsdck
%{_bindir}/rvp
%{_mandir}/man1/rnv.1*
%{_mandir}/man1/rvp.1*
%{_mandir}/man1/arx.1*
%{_mandir}/man1/xsdck.1*
%dir %{_sysconfdir}/rnv
%config(noreplace) %{_sysconfdir}/rnv/arx.conf
%doc COPYING ChangeLog readme.txt
%docdir %{_docdir}/rnv/examples
%doc %{_docdir}/rnv/examples/rvp.py*
%doc %{_docdir}/rnv/examples/rvp.pl

%files -n vim-rnv
%{_datadir}/vim/vimfiles/plugin/rnv.vim
%{_datadir}/appdata/vim-rnv.metainfo.xml

%changelog
