# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           rolisteam
Version:        1.9.3
Release:        alt1_3
Summary:        A program to manage a tabletop role-playing game with remote players
Group:          Games/Other
License:        GPLv3
Url:            https://www.rolisteam.org
Source0:        https://downloads.sf.net/rolisteam/%{name}-%{version}.tar.gz

BuildRequires:  icoutils icoutils-extra
BuildRequires:  pkgconfig(Qt5Core)
BuildRequires:  pkgconfig(Qt5Gui)
BuildRequires:  pkgconfig(Qt5Multimedia)
BuildRequires:  pkgconfig(Qt5Network)
BuildRequires:  pkgconfig(Qt5OpenGL)
BuildRequires:  pkgconfig(Qt5PrintSupport)
BuildRequires:  pkgconfig(Qt5Qml)
BuildRequires:  pkgconfig(Qt5Quick)
BuildRequires:  pkgconfig(Qt5QuickWidgets)
BuildRequires:  pkgconfig(Qt5Svg)
BuildRequires:  pkgconfig(Qt5WebEngine)
BuildRequires:  pkgconfig(Qt5WebEngineWidgets)
BuildRequires:  pkgconfig(Qt5Widgets)
BuildRequires:  pkgconfig(Qt5Xml)
BuildRequires:  pkgconfig(zlib)
BuildRequires:  qt5-designer qt5-tools
Source44: import.info

%description
Rolisteam helps you to manage a tabletop role-playing game with remote
friends/players. It provides many features to share maps and pictures, and it
also includes some tools to communicate with the other participants.

%prep
%setup -q


%build
%qmake_qt5 PREFIX=%{_gamesbindir}
%make_build

%install
%makeinstall_std INSTALL_ROOT=%{buildroot}

install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/%{name}.desktop
[Desktop Entry]
Name=Rolisteam
Comment=A program to manage a tabletop role-playing game with remote players
GenericName=Role-playing game manager
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;RolePlaying;
EOF

install -D resources/logo/symbol.svg %{buildroot}%{_iconsdir}/hicolor/scalable/apps/%{name}.svg
icotool -x 256.ico
install -D 256_1_256x256x32.png %{buildroot}%{_iconsdir}/hicolor/256x256/apps/%{name}.png

%files
%doc AUTHORS COPYRIGHT README.md
%{_gamesbindir}/%{name}
%{_gamesbindir}/roliserver
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/*/apps/%{name}.*


%changelog
