# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/fakeroot /usr/bin/stunnel /usr/bin/yodl2man perl(Date/Format.pm) perl(Term/ReadKey.pm) zlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           rsync-bpc
Version:        3.1.3.0
Release:        alt1_3
Summary:        A customized version of rsync that is used as part of BackupPC
License:        GPLv3+
Group:          Networking/File transfer
URL:            https://github.com/backuppc/rsync-bpc
Source0:        https://github.com/backuppc/rsync-bpc/releases/download/%{version}/%{name}-%{version}.tar.gz
Patch1:         rsync-bpc-configure-c99.patch
BuildRequires:  libacl-devel
BuildRequires:  libattr-devel
BuildRequires:  libpopt-devel

Provides:       bundled(rsync) = 3.1.3
Source44: import.info

%description
Rsync-bpc is a customized version of rsync that is used as part of
BackupPC, an open source backup system.

The main change to rsync is adding a shim layer (in the subdirectory
backuppc, and in bpc_sysCalls.c) that emulates the system calls for
accessing the file system so that rsync can directly read/write files
in BackupPC's format.

Rsync-bpc is fully line-compatible with vanilla rsync, so it can talk
to rsync servers and clients.

Rsync-bpc serves no purpose outside of BackupPC.


%prep
%setup -q
%patch1 -p1


# fix build on aarch64
cp -af /usr/share/gnu-config/config.{guess,sub} .

%build
%configure
%make_build

%install
%makeinstall_std

%files
%doc NEWS README
%doc --no-dereference COPYING
%{_bindir}/rsync_bpc


%changelog
