Group: Networking/WWW
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global commit f1b83c10d8beb43fcc70a6e88cf4325499f25857
%global shortcommit %(c=%{commit}; echo ${c:0:7})
%global gitdate 20210219

Name:           rtmpdump
Version:        2.4
Release:        alt2_24.%{gitdate}.git%{shortcommit}
Summary:        Toolkit for RTMP streams

# The tools are GPLv2+. The library is LGPLv2+, see below.
License:        GPLv2+
URL:            https://rtmpdump.mplayerhq.hu/
Source0:        https://git.ffmpeg.org/gitweb/rtmpdump.git/snapshot/%{commit}.tar.gz#/rtmpdump-%{shortcommit}.tar.gz
Patch0:         gcc14_buildfix.patch

BuildRequires:  gcc
BuildRequires:  libgnutls-devel libgnutlsxx-devel
BuildRequires:  libgcrypt-devel
BuildRequires:  zlib-devel
BuildRequires:  libnettle-devel

# we should force the exact EVR for an ISA - not only the same ABI
Requires: librtmp = %{version}-%{release}
Source44: import.info

%description
rtmpdump is a toolkit for RTMP streams. All forms of RTMP are supported,
including rtmp://, rtmpt://, rtmpe://, rtmpte://, and rtmps://.

%package -n librtmp
Group: Networking/WWW
Summary:        Support library for RTMP streams
License:        LGPLv2+

%description -n librtmp
librtmp is a support library for RTMP streams. All forms of RTMP are supported,
including rtmp://, rtmpt://, rtmpe://, rtmpte://, and rtmps://.

%package -n librtmp-devel
Group: Networking/WWW
Summary:        Files for librtmp development
License:        LGPLv2+
Requires:       librtmp = %{version}-%{release}

%description -n librtmp-devel
librtmp is a support library for RTMP streams. The librtmp-devel package
contains include files needed to develop applications using librtmp.

%prep
%setup -q -n %{name}-%{shortcommit}
%patch0 -p1


%build
# The fact that we have to add -ldl for gnutls is Fedora bug #611318
make SYS=posix CRYPTO=GNUTLS SHARED=yes OPT="%{optflags}" LIB_GNUTLS="-lgnutls -lgcrypt -ldl -lz"

%install
make CRYPTO=GNUTLS SHARED=yes DESTDIR=%{buildroot} prefix=%{_prefix} mandir=%{_mandir} libdir=%{_libdir} install
rm -f %{buildroot}%{_libdir}/librtmp.a



%files
%doc README
%doc --no-dereference COPYING
%{_bindir}/rtmpdump
%{_sbindir}/rtmpsrv
%{_sbindir}/rtmpgw
%{_sbindir}/rtmpsuck
%{_mandir}/man1/rtmpdump.1*
%{_mandir}/man8/rtmpgw.8*

%files -n librtmp
%doc ChangeLog
%doc --no-dereference librtmp/COPYING
%{_libdir}/librtmp.so.1

%files -n librtmp-devel
%{_includedir}/librtmp/
%{_libdir}/librtmp.so
%{_libdir}/pkgconfig/librtmp.pc
%{_mandir}/man3/librtmp.3*

%changelog
