Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: libsndfile-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		rtpproxy
Version:	2.0.0
Release:	alt2_22
Summary:	A symmetric RTP proxy
License:        BSD
URL:		http://www.rtpproxy.org
VCS:		scm:git:https://github.com/sippy/rtpproxy.git
Source0:	https://github.com/sippy/rtpproxy/archive/v%{version}/%{name}-%{version}.tar.gz
Patch1:		rtpproxy-0001-Remove-more-autogenerated-stuff.patch
Patch2:		rtpproxy-0002-Fedora-related-fix-for-docbook-path.patch
Patch3:		rtpproxy-0003-Updated-SysV-init-script-for-legacy-systems.patch
Patch4:		rtpproxy-0004-Fix-build-with-the-bcg729-1.0.2.patch
# https://lists.fedoraproject.org/archives/list/devel@lists.fedoraproject.org/message/Y6V2KRAYAWMX5KRPRXCHISTQL7STKRLP
Patch5:		rtpproxy-glibc-nosysctl.patch

BuildRequires:	libsystemd-devel libudev-devel
# For /usr/lib/rpm/macros.d/macros.systemd
BuildRequires:  libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
BuildRequires:	libgsm-devel
BuildRequires:	libxslt xsltproc
BuildRequires:	docbook-style-xsl
BuildRequires:	libbcg729 libbcg729-devel
BuildRequires:	autoconf
BuildRequires:	automake
BuildRequires:	libtool
Requires(pre):	/usr/sbin/useradd
Source44: import.info


%description
This is symmetric RTP proxy designed to be used in conjunction with
the SIP Express Router (SER) or any other SIP proxy capable of
rewriting SDP bodies in SIP messages that it processes.


%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1



%build
autoreconf -ivf
%configure --enable-systemd
%make_build
make rtpproxy.8


%install
make install DESTDIR=%{buildroot}
install -D -p -m 0644 rpm/%{name}.sysconfig %{buildroot}%{_sysconfdir}/sysconfig/%{name}
# install systemd files
install -D -m 0644 -p rpm/%{name}.service %{buildroot}%{_unitdir}/%{name}.service
install -D -m 0644 -p rpm/%{name}.socket %{buildroot}%{_unitdir}/%{name}.socket
install -D -m 0644 -p rpm/%{name}.tmpfiles.conf %{buildroot}%{_tmpfilesdir}/%{name}.conf
mkdir -p %{buildroot}%{_localstatedir}/run/%{name}
install -d %{buildroot}%{_localstatedir}/lib/%{name}


%pre
getent passwd %{name} >/dev/null || \
/usr/sbin/useradd -r -c "RTPProxy service"  -d %{_localstatedir}/lib/%{name} -s /sbin/nologin %{name} 2>/dev/null || :


%post
%post_service %{name}


%preun
%preun_service %{name}


%files
%doc AUTHORS README.md README.remote
%doc --no-dereference LICENSE
%config(noreplace) %{_sysconfdir}/sysconfig/%{name}
%{_unitdir}/%{name}.service
%{_unitdir}/%{name}.socket
%{_tmpfilesdir}/%{name}.conf
%dir %attr(0755, rtpproxy, rtpproxy) %{_localstatedir}/run/%{name}
%exclude %{_bindir}/rtpproxy_debug
%{_bindir}/rtpproxy
%{_bindir}/makeann
%{_mandir}/man8/rtpproxy.8*
%dir %attr(0750, rtpproxy, rtpproxy) %{_localstatedir}/lib/%{name}


%changelog
