# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define pkgname debianutils

Name:       run-parts
Version:    4.8.4
Release:    alt1_4
Epoch:      1
Summary:    Run scripts or programs in a directory
License:    GPLv2+
Group:      System/Base
URL:        https://salsa.debian.org/debian/debianutils
Source0:    https://ftp.debian.org/debian/pool/main/d/%{pkgname}/%{pkgname}_%{version}.tar.xz
Patch0:     %{name}-3.2.1-mga-blacklist-rpm-files.patch
Patch1:     %{name}-3.2.1-mga-allow-dots-in-filenames.patch
Source44: import.info

%description
run-parts runs a number of scripts or programs found in a single
directory. Filenames should consist entirely of upper and lower
case letters, digits, underscores, and hyphens. Subdirectories of
directory and files with other names will be silently ignored.


%prep
%setup -q -n %{pkgname}
%patch0 -p1
%patch1 -p1


%build
%configure
%make_build

%install
install -D -m 755 %{name}  %{buildroot}%{_bindir}/%{name}
install -D -m 644 %{name}.8  %{buildroot}%{_mandir}/man8/%{name}.8
for lang in de es fr sl; do
    install -D -m 644 po4a/$lang/%{name}.8  %{buildroot}%{_mandir}/$lang/man8/%{name}.8
done

%find_lang %{name} --with-man

%files -f %{name}.lang
%doc debian/changelog debian/copyright
%{_bindir}/run-parts
%{_mandir}/man8/run-parts.8*


%changelog
