Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%if %{?WITH_SELINUX:0}%{!?WITH_SELINUX:1}
%global WITH_SELINUX 1
%endif

Summary: Displays the users logged into machines on the local network
Name: rusers
Version: 0.17
Release: alt1_96
License: BSD
Url: http://rstatd.sourceforge.net/
Source: http://ftp.linux.org.uk/pub/linux/Networking/netkit/netkit-rusers-%{version}.tar.gz
Source1: rusersd.service
Source2: rstatd.tar.gz
Source3: rstatd.service
Patch0: rstatd-jbj.patch
Patch1: netkit-rusers-0.15-numusers.patch
Patch2: rusers-0.17-2.4.patch
Patch3: rusers-0.17-includes.patch
Patch4: rusers-0.17-truncate.patch
Patch5: rusers-0.17-stats.patch
Patch6: rusers-0.17-rstatd-no-static-buffer.patch
Patch7: rusers-0.17-strip.patch
Patch8: rusers-0.17-rup.patch
Patch9: rusers-0.17-rup-timeout.patch
Patch10: rusers-0.17-procps.patch
Patch11: rusers-0.17-rup-stack.patch
Patch12: rusers-0.17-bigendian.patch
Patch13: rusers-0.17-return.patch
Patch14: rusers-0.17-procdiskstats.patch
Patch15: rusers-0.17-rusersd-droppriv.patch
# Oracle explicitly gave permission for this relicensing on August 18, 2010.
Patch16: rusers-0.17-new-rpc-license.patch
Patch17: rusers-0.17-manhelp.patch
Patch18: rusers-0.17-freerpc.patch
Patch19: rstatd-man.patch
# Provide the BSD 3-clause license text as COPYING file
Patch20: rusers-0.17-license.patch
BuildRequires: gcc
BuildRequires: procps libselinux-devel
BuildRequires: glibc-devel
BuildRequires: glibc-utils
BuildRequires: libtirpc-devel
Source44: import.info

%description
The rusers program allows users to find out who is logged into various
machines on the local network.  The rusers command produces output
similar to who, but for the specified list of hosts or for all
machines on the local network.

Install rusers if you need to keep track of who is logged into your
local network.

%package server
Group: Other
Summary: Server for the rusers protocol
Requires: portmap
BuildRequires: libsystemd-devel libudev-devel systemd systemd-analyze systemd-coredump systemd-homed systemd-networkd systemd-portable systemd-services systemd-stateless systemd-sysvinit systemd-utils
BuildRequires: libsystemd-devel libudev-devel

%description server
The rusers program allows users to find out who is logged into various
machines on the local network.  The rusers command produces output
similar to who, but for the specified list of hosts or for all
machines on the local network. The rusers-server package contains the
server for responding to rusers requests.

Install rusers-server if you want remote users to be able to see
who is logged into your machine.

%prep
%setup -q -n netkit-rusers-%{version} -a 2
%patch0 -p1 -b .jbj
%patch1 -p1 -b .numusers
%patch2 -p1 -b .2.4
%patch3 -p1 -b .includes
%patch4 -p1 -b .truncate
%patch5 -p1 -b .stats
%patch6 -p1 -b .rstatd-no-static-buffer
%patch7 -p1 -b .strip
%patch8 -p1 -b .rup
%patch9 -p1 -b .rup-timeout
%patch10 -p1 -b .procps
%patch11 -p1 -b .rup-stack
%patch12 -p1 -b .bigendian
%patch13 -p1 -b .return
%patch14 -p1 -b .procdiskstats
%patch15 -p1 -b .dropprivs
%patch16 -p1 -b .licensefix
%patch17 -p1 -b .manhelp
%patch18 -p1 -b .freerpc
%patch19 -p1 -b .rstatd-man
%patch20 -p1 -b .license

%build
cat > MCONFIG <<EOF
# Generated by configure (confgen version 2) on Wed Jul 17 09:33:22 EDT 2002
#

BINDIR=%{_bindir}
SBINDIR=%{_sbindir}
MANDIR=%{_mandir}
BINMODE=755
DAEMONMODE=755
MANMODE=644
PREFIX=/usr
EXECPREFIX=/usr
INSTALLROOT=
CC=cc
CFLAGS=${RPM_OPT_FLAGS} -I/usr/include/tirpc -fPIC -Wall -W -Wpointer-arith -Wbad-function-cast -Wcast-qual -Wstrict-prototypes -Wmissing-prototypes -Wmissing-declarations -Wnested-externs -Winline
LDFLAGS=-pie -Wl,-z,relro,-z,now -ltirpc
LIBS=-lsystemd
USE_GLIBC=1

EOF

make
%if %{WITH_SELINUX}
make LIBS="-lselinux -lsystemd" -C rpc.rstatd
%else
make -C rpc.rstatd
%endif


%install
mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man{1,8}
mkdir -p ${RPM_BUILD_ROOT}%{_unitdir}

make INSTALLROOT=${RPM_BUILD_ROOT} install
make INSTALLROOT=${RPM_BUILD_ROOT} install -C rpc.rstatd

install -m 0644 %SOURCE1 ${RPM_BUILD_ROOT}%{_unitdir}/rusersd.service
install -m 0644 %SOURCE3 ${RPM_BUILD_ROOT}%{_unitdir}/rstatd.service

%post server
%post_service rstatd
%post_service rusersd

%preun server
%preun_service rstatd
%preun_service rusersd

%files
%doc README COPYING
%{_bindir}/rup
%{_bindir}/rusers
%{_mandir}/man1/*

%files server
%doc COPYING
%{_mandir}/man8/*
%{_sbindir}/rpc.rstatd
%{_sbindir}/rpc.rusersd
%{_unitdir}/rusersd.service
%{_unitdir}/rstatd.service

%changelog
