Group: System/Servers
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: Displays who is logged in to local network machines
Name: rwho
Version: 0.17
Release: alt2_80
# part of rwhod is under GPL+, other parts are under BSD
# Automatically converted from old format: BSD and GPL+ - review is highly recommended.
License: LicenseRef-Callaway-BSD AND GPL-1.0-or-later
Source: ftp://ftp.uk.linux.org/pub/linux/Networking/netkit/netkit-rwho-%{version}.tar.gz
Source1: rwhod.service
Patch0: rwho-0.15-alpha.patch
Patch1: rwho-0.17-bug22014.patch
Patch2: rwho-0.17-fixbcast.patch
Patch3: rwho-0.17-fixhostname.patch
Patch4: rwho-0.17-strip.patch
Patch5: rwho-0.17-include.patch
Patch6: rwho-0.17-wd_we.patch
Patch7: rwho-0.17-time.patch
Patch8: rwho-0.17-gcc4.patch
Patch9: rwho-0.17-waitchild.patch
Patch10: rwho-0.17-neighbours.patch
Patch11: rwho-0.17-hostnamelen.patch
Patch12: rwho-0.17-stderr.patch
Patch13: rwho-c99.patch
BuildRequires: gcc
BuildRequires: libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd, perl-devel
Source44: import.info

%description
The rwho command displays output similar to the output of the who
command (it shows who is logged in) for all machines on the local
network running the rwho daemon.

Install the rwho command if you need to keep track of the users who
are logged in to your local network.

%prep
%setup -q -n netkit-rwho-%{version}
%patch0  -p1 -b .alpha
%patch1  -p1 -b .bug22014
%patch2  -p1 -b .fixbcast
%patch3  -p1 -b .fixhostname
%patch4  -p1 -b .strip
%patch5  -p1 -b .include
%patch6  -p1 -b .wd_we
%patch7  -p1 -b .time
%patch8  -p1 -b .gcc4
%patch9  -p1 -b .waitchild
%patch10  -p1 -b .neighbours
%patch11  -p1 -b .hostnamelen
%patch12  -p1 -b .stderr
%patch13  -p1

/usr/bin/perl -pi -e '
    s|^LDFLAGS=|LDFLAGS="-pie -Wl,-z,relro,-z,now"|;
    s,^BINDIR=.*$,BINDIR=%{_bindir},;
    s,^MANDIR=.*$,MANDIR=%{_mandir},;
    s,^SBINDIR=.*$,SBINDIR=%{_sbindir},;
    ' configure

%build
%ifarch s390 s390x
CFLAGS="$RPM_OPT_FLAGS -I../include -fPIC" \
%else
CFLAGS="$RPM_OPT_FLAGS -I../include -fpic" \
%endif
sh configure --with-c-compiler=gcc
%make_build

%install
mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man{1,8}
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
mkdir -p ${RPM_BUILD_ROOT}%{_unitdir}
mkdir -p ${RPM_BUILD_ROOT}/var/spool/rwho

make INSTALLROOT=${RPM_BUILD_ROOT} install
make INSTALLROOT=${RPM_BUILD_ROOT} install -C ruptime

install -m 644 %SOURCE1 ${RPM_BUILD_ROOT}%{_unitdir}/rwhod.service

%post
%post_service rwhod

%preun
%preun_service rwhod

%files
%doc README
%{_bindir}/ruptime
%{_mandir}/man1/ruptime.1*
%{_bindir}/rwho
%{_mandir}/man1/rwho.1*
%{_sbindir}/rwhod
%{_mandir}/man8/rwhod.8*
/var/spool/rwho
%{_unitdir}/*

%changelog
