# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-python3
# END SourceDeps(oneline)
Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name safekeep
%define name    safekeep
%define version 1.5.1
%define release 8
%define apphomedir %{_localstatedir}/lib/%{name}

Name:           %{name}
Version:        %{version}
Release:        alt2_8
Summary:        The SafeKeep backup system

License:        GPL-2.0-or-later
URL:            http://%{name}.sourceforge.net
Source0:        https://github.com/dimipaun/%{name}/archive/%{version}.tar.gz#/%{name}-%{version}.tar.gz
Source1:        README.Fedora

BuildArch:      noarch
BuildRequires:  xmlto asciidoc asciidoc-a2x
Source44: import.info

%description
SafeKeep is a client/server backup system which enhances the
power of rdiff-backup with simple, centralized configuration.

%package common
Group: Other
Summary:        The SafeKeep backup system (common component)
Requires:       rdiff-backup
Requires:       python3 >= 3.4

%description common
SafeKeep is a client/server backup system which enhances the
power of rdiff-backup with simple, centralized configuration.

This is the common component of SafeKeep. It is shared in 
between the client/server components.

%package client
Group: Other
Summary:        The SafeKeep backup system (client component)
Requires:       openssh-server
Requires:       coreutils
Requires:       cfdisk eject fdisk getopt hwclock look lsblk msulogin rfkill setarch sfdisk shadow-change util-linux
Requires:       %{name}-common = %{version}-%{release}

%description client
SafeKeep is a client/server backup system which enhances the
power of rdiff-backup with simple, centralized configuration.

This is the client component of SafeKeep. It should be
installed on all hosts that need to be backed-up.

%package server
Group: Other
Summary:        The SafeKeep backup system (server component)
Requires(pre):  %{_sbindir}/useradd
Requires(pre):  %{_sbindir}/groupadd
Requires:       openssh, openssh-clients
Requires:       %{name}-common = %{version}-%{release}
Requires:       crontabs

%description server
SafeKeep is a client/server backup system which enhances the
power of rdiff-backup with simple, centralized configuration.

This is the server component of SafeKeep. It should be
installed on the server on which the data will be backed-up to.

%prep
%setup -q
cp -p %{SOURCE1} .

%build
%make_build build

%install
make install DESTDIR=%{buildroot}
install -d -m 750 "%{buildroot}%{apphomedir}"
install -d -m 700 "%{buildroot}%{apphomedir}/.ssh"

%pre server
%{_sbindir}/groupadd -f -r %{name}
id %{name} >/dev/null 2>&1 || \
%{_sbindir}/useradd -r -g %{name} -d %{apphomedir} -s /sbin/nologin \
  -c "Used by %{name} to run and store backups." %{name}

%files common
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*
%doc AUTHORS COPYING README INSTALL TODO samples/client-script-sample.sh
%{!?_licensedir:%global license %doc}
%doc --no-dereference LICENSE
%doc README.Fedora

%files client

%files server
%attr(750,%{name},%{name}) %dir %{apphomedir}
%attr(700,%{name},%{name}) %dir %{apphomedir}/.ssh
%dir %{_sysconfdir}/%{name}
%dir %{_sysconfdir}/%{name}/backup.d
%config(noreplace) %{_sysconfdir}/%{name}/%{name}.conf
%{_sysconfdir}/cron.daily/%{name}
%{_mandir}/man5/%{name}.conf.5*
%{_mandir}/man5/%{name}.backup.5*
%doc samples/sample.backup

%changelog
