# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define build_plf 0
%{?_with_plf: %global build_plf 1}

%define tiff22pnm_version 2014-01-09

# enablelzw = 0 (don't build with LZW compression support)
# enablelzw = 1 (build with LZW compression support)
# Currently we use enablelzw = 0 due to Unisys LZW patents.
%define enablelzw       0

%if %build_plf
%define enablelzw       1
%endif

Summary:	Convert raster images to PostScript or PDF
Name:		sam2p
Version:	0.49.4
Release:	alt1_1
License:	GPLv2+
Group:		Publishing
URL:		https://github.com/pts/sam2p
Source0:	https://github.com/pts/sam2p/releases/download/v%{version}/%{name}-%{version}.tar.gz
Source1:	https://github.com/pts/tif22pnm/archive/%{tiff22pnm_version}.tar.gz
# (tv) fix linking:
Patch0:		fix-linking.diff
Patch1:		sam2p-0.49.2-mga-deps.diff
# from gentoo
Patch20:	sam2p-0.49.4_p20190718-fix-configure-clang.patch
Requires:	ghostscript
Requires:	libjpeg-utils
BuildRequires:	libjpeg-utils
Requires:	netpbm
BuildRequires:	libtiff-devel libtiffxx-devel
BuildRequires:	pkgconfig(libpng16)
Source44: import.info

%description
sam2p is a UNIX command line utility written in ANSI C++ that converts
many raster (bitmap) image formats into Adobe PostScript or PDF files
and several other formats. The images are not vectorized. sam2p gives
full control to the user to specify standards-compliance, compression,
and bit depths. In some cases sam2p can compress an image 100 times
smaller than the PostScript output of many other common image
converters. sam2p provides ZIP, RLE and LZW (de)compression filters
even on Level1 devices.

%prep
%setup -q -n %{name}-%{version} -a 1
%patch0 -p1
%patch1 -p1
%patch20 -p1


# configure.in files are deprecated
mv configure.{in,ac}

# missing include for memset
sed -i '1s;^;#include <string.h>\n;' pts_defl.c

%build

pushd tif22pnm-%{tiff22pnm_version}
autoconf -f
# Abuse CPPFLAGS to hold our CFLAGS since it's the only way
%configure \
	--with-libtiff-idir=%{_includedir} \
	--with-libpng-idir=%{_includedir}/libpng16 \
	--with-libtiff-ldir=%{_libdir} \
	--with-libpng-ldir=%{_libdir} \
	--enable-debug=yes \
	CPPFLAGS="$CFLAGS"
make
cp tif22pnm png22pnm ../
cp -p README ../README.tif22pnm
popd

autoconf -f
%configure \
%if %build_plf
	--enable-lzw \
%endif
	--enable-gif

%make_build CXXFLAGS="$CXXFLAGS" LDXX=g++ ENABLE_DEBUG=yes GFLAG=-DNDEBUG


%install
mkdir -p %{buildroot}%{_bindir}
install -m 755 sam2p tif22pnm png22pnm %{buildroot}%{_bindir}

%files
%doc --no-dereference COPYING
%doc README README.tif22pnm examples contrib
%{_bindir}/sam2p
%{_bindir}/tif22pnm
%{_bindir}/png22pnm


%changelog
