Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate gcc-c++
# END SourceDeps(oneline)
%define fedora 31
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define __cmake_in_source_build 1

%global cmake_build_dir build-cmake
%global debug_package %{nil}
%bcond_without qt4
%bcond_without qt5

Name:           se-sandbox-runner
Version:        1.7.14
Release:        alt1_13
Summary:        Qt wrapper for SELinux Sandbox
License:        GPLv2+
Source0:        https://github.com/F1ash/%{name}/archive/%{version}.tar.gz
URL:            https://github.com/F1ash/%{name}

Requires:       xdg-utils
Requires:       icon-theme-hicolor
Requires:       policycoreutils-sandbox
%if (0%{?fedora} >= 20)
Requires:       selinux-policy-sandbox
%endif
Conflicts:      se-sandbox-runner
%if %with qt4
BuildRequires:  libqt4-declarative libqt4-devel libqt4-help qt4-designer qt4-doc-html qt5-declarative-devel qt5-designer qt5-tools
%endif
%if %with qt5
BuildRequires:  qt5-base-devel
%endif
BuildRequires:  desktop-file-utils
BuildRequires:  ctest cmake
Source44: import.info

%description
Qt wrapper for SELinux Sandbox.
This application runs and controls the configured jobs, running in a sandbox.
Job settings are saved in the application's configuration.

%package        qt4
Group: Other
Summary:        Qt4 wrapper for SELinux Sandbox

%description    qt4
Qt4 wrapper for SELinux Sandbox.
This application runs and controls the configured jobs, running in a sandbox.
Job settings are saved in the application's configuration.

%package        qt5
Group: Other
Summary:        Qt5 wrapper for SELinux Sandbox

%description    qt5
Qt5 wrapper for SELinux Sandbox.
This application runs and controls the configured jobs, running in a sandbox.
Job settings are saved in the application's configuration.

%prep
%setup -q

%build
%if %with qt4
mkdir %{cmake_build_dir}-qt4
pushd %{cmake_build_dir}-qt4
      %{fedora_v2_cmake} ..
      %{make_build}
popd
%endif
%if %with qt5
mkdir %{cmake_build_dir}-qt5
pushd %{cmake_build_dir}-qt5
      %{fedora_v2_cmake} -DBUILD_QT_VERSION=5 ..
      %{make_build}
popd
%endif

%install
%if %with qt4
pushd %{cmake_build_dir}-qt4
      %{makeinstall_std}
popd
%endif
%if %with qt5
pushd %{cmake_build_dir}-qt5
      %{makeinstall_std}
popd
%endif

%check
%if %with qt4
desktop-file-validate %{buildroot}/%{_datadir}/applications/%{name}-qt4.desktop
%endif
%if %with qt5
desktop-file-validate %{buildroot}/%{_datadir}/applications/%{name}-qt5.desktop
%endif

%if %with qt4
%files qt4
%doc README.md Changelog
%doc --no-dereference COPYING
%{_bindir}/%{name}-qt4
%{_datadir}/applications/%{name}-qt4.desktop
%{_datadir}/icons/hicolor/256x256/apps/applications-safety-selinux.png
%endif
%if %with qt5
%files qt5
%doc README.md Changelog
%doc --no-dereference COPYING
%{_bindir}/%{name}-qt5
%{_datadir}/applications/%{name}-qt5.desktop
%{_datadir}/icons/hicolor/256x256/apps/applications-safety-selinux.png
%endif

%changelog
