# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	Asynchronous file transfer service
Name:		sendfile
Version:	2.1b
Release:	alt1_16
License:	GPLv2
Group:		Networking/File transfer
URL:		https://www.belwue.de/projekte/saft/sendfile.html
Source:		%{name}-%{version}.tar.bz2
Source1:	sendfile-xinetd
#patch0 sent upstream (Kharec)
Patch0:		sendfile-2.1b-fix-str-fmt.patch
Patch1:		sendfile-fix-build-with-gcc14.patch
Requires:	xinetd
BuildRequires:	libreadline-devel
Source44: import.info

%description
Sendfile is an asynchronous file transfer service for the Internet, like the
sendfile facility in Bitnet: Any user A can send files to another user B
without B being active in any way.

Sendfile which is an implementation of the SAFT protocol (Simple Asynchronous
File Transfer) offers you a true asynchronous file transfer service for the
Internet. Virtually any form of file can be sent, including encrypted ones.

The sendfile package contains 5 main programs:
  sendfiled  - the sendfile daemon which will be started by inetd
  sendfile   - the sendfile client for sending files
  sendmsg    - the send-message client for sending one-line text messages
  receive    - the receive client for picking up already received files
  fetchfile  - the O-SAFT client to obtain files from a remote SAFT server


%prep
%setup -q
%patch0
%patch1


# fix build on aarch64
cp -af /usr/share/gnu-config/config.{guess,sub} develop/

%build
%make_build CFLAGS="%{optflags} -DLINUX" LDFLAGS=""

%install
# install isn't good, so we do it by hand...
install -d %buildroot/%_sbindir
install src/sendfiled %buildroot/%_sbindir/
install -d %buildroot/%_var/spool/sendfile/LOG
install -d %buildroot/%_var/spool/sendfile/OUTGOING
install -d %buildroot/%_sysconfdir
install etc/sendfile.deny %buildroot/%_sysconfdir/
install etc/sendfile.cf %buildroot/%_sysconfdir/
install -D %SOURCE1 %buildroot/%_sysconfdir/xinetd.d/sendfile
install -d %buildroot/%_mandir/man1/
install doc/*.1 %buildroot/%_mandir/man1/
install -d %buildroot/%_mandir/man1
install -D etc/check_sendfile %buildroot/%_sysconfdir/profile.d/sendfile-check.sh
install -d %buildroot/%_bindir
install src/{sendfile,sendmsg,receive,fetchfile,utf7encode,wlock} %buildroot/%_bindir/
ln -s utf7encode %buildroot/%_bindir/utf7decode
install etc/{sfconf,sfdconf} %buildroot/%_bindir/

%post
service xinetd reload

%postun
service xinetd reload

%files
#%defattr(0755,root,root,0755)
%_sbindir/*
%_bindir/*
%doc doc/AUTHORS doc/COPYING doc/ChangeLog doc/doc.txt doc/doku.txt
%doc doc/features doc/LIESMICH* doc/README* doc/THANKS doc/vorteile
%dir %_var/spool/sendfile
%attr(0700,root,root) %dir %_var/spool/sendfile/LOG
%attr(1777,root,root) %dir %_var/spool/sendfile/OUTGOING
%config(noreplace) %_sysconfdir/sendfile.*
%config(noreplace) %_sysconfdir/profile.d/*
%config(noreplace) %_sysconfdir/xinetd.d/*
%_mandir/*/*






%changelog
