Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/xmltoman libao-devel libavutil-devel libjack-devel libmbedtls-devel libmosquitto-devel libsndfile-devel libsoundio-devel pkgconfig(gio-unix-2.0)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           shairport-sync
Version:        3.3.9
Release:        alt1_1
Summary:        AirTunes emulator. Multi-Room with Audio Synchronisation
# MIT licensed except for tinysvcmdns under BSD, 
# FFTConvolver/ under GPLv3+ and audio_sndio.c 
# under ISC
License:        MIT and BSD and GPLv3+ and ISC
URL:            https://github.com/mikebrady/shairport-sync
Source0:        https://github.com/mikebrady/%{name}/archive/%{version}/%{name}-%{version}.tar.gz

%{?systemd_requires}
Requires: avahi-daemon libavahi
BuildRequires:  libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
BuildRequires:  pkgconfig(libconfig)
BuildRequires:  pkgconfig(popt)
BuildRequires:  pkgconfig(openssl)
BuildRequires:  pkgconfig(libdaemon)
BuildRequires:  pkgconfig(avahi-core)
BuildRequires:  pkgconfig(alsa)
BuildRequires:  pkgconfig(soxr)
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:	gcc
BuildRequires:	gcc-c++
BuildRequires:	pkgconfig(libpulse)
Source44: import.info

%description
Shairport Sync emulates an AirPort Express for the purpose of streaming audio
 from iTunes, iPods, iPhones, iPads and AppleTVs. Audio played by a Shairport
 Sync-powered device stays synchronised with the source and hence with similar
 devices playing the same source. Thus, for example, synchronised multi-room
 audio is possible without difficulty. (Hence the name Shairport Sync, BTW.)

Shairport Sync does not support AirPlay video or photo streaming.

%prep
%setup -q

%build
autoreconf -i -f
%configure --with-avahi --with-alsa --with-ssl=openssl --with-soxr \
           --with-pipe --with-dummy --with-stdout --with-pa --with-metadata
%make_build

%install
%makeinstall_std
rm %{buildroot}/etc/shairport-sync.conf.sample
install -p -m644 -D scripts/shairport-sync.service %{buildroot}%{_unitdir}/%{name}.service
mkdir -p %{buildroot}/%{_sharedstatedir}/%{name}

%pre
getent group %{name} >/dev/null || groupadd --system %{name}
getent passwd %{name} > /dev/null || useradd --system -c "%{name} User" \
        -d %{_sharedstatedir}/%{name} -g %{name} -s /sbin/nologin \
        -G audio %{name}
exit 0

%post
%post_service %{name}

%preun
%preun_service %{name}

%files
%config(noreplace) /etc/shairport-sync.conf
/usr/bin/shairport-sync
/usr/share/man/man7/shairport-sync.7*
%{_unitdir}/%{name}.service
%doc README.md RELEASENOTES.md TROUBLESHOOTING.md
%doc --no-dereference LICENSES
%attr(-, %{name}, %{name}) %{_sharedstatedir}/%{name}

%changelog
