Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# add --without testsuite option, i.e. enable testsuite by default
%bcond_without testsuite

Name:           shedskin
Version:        0.9.4
Release:        alt1_11
Summary:        Python to C++ compiler

# The dict implementation in shedskin/lib/builtin.cpp is under the Python
# license. The Murmurhash implementation in builtin.cpp is bundled (noted
# below) and licensed MIT.
# Other files in shedskin/lib/ are MIT, rest GPLv3
# WTFPL: print_stacktrace function in shedskin/lib/builtin.hpp
License:        GPLv3 and (MIT and Python) and WTFPL
URL:            http://code.google.com/p/shedskin/
Source0:        http://shedskin.googlecode.com/files/shedskin-%{version}.tgz

BuildArch:      noarch
BuildRequires:  python-devel
BuildRequires:  python-module-pkg_resources python-module-setuptools

# Required for running the testsuite:
BuildRequires:  libgc-devel
BuildRequires:  gcc-c++
BuildRequires:  libpcre-devel libpcrecpp-devel

# Require all devel packages for making a binary
# <gc/gc_allocator.h>
# <sys/types.h>
Requires:       gcc-c++
# <pcre.h>
# <Python.h>

# murmurhash is bundled in shedskin/lib/buildin.cpp as a hash function
# http://sites.google.com/site/murmurhash/
# fpc exception granted at:
# https://fedorahosted.org/fpc/ticket/39
Provides:       bundled(murmurhash) = 2
Source44: import.info

%description
Shed Skin is an experimental compiler, that can translate pure, but
implicitly statically typed Python programs into optimized C++. It can
generate stand-alone programs or extension modules, that can be imported
and used in larger Python programs.


%prep
%setup -q -n %{name}-%{version}


%build
%python_build


%install
%python_install


%check
%if %{with testsuite}
%{__python} setup.py test
%endif

 

%files
%doc LICENSE README doc/
%{_bindir}/shedskin
%{python_sitelibdir_noarch}/shedskin/
%{python_sitelibdir_noarch}/shedskin-*.egg-info


%changelog
