Group: Development/Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       shflags
Version:    1.0.3
Release:    alt1_15
Summary:    Simple handling of command-line flags in Bourne based Unix scripts

License:    LGPLv2
URL:        http://code.google.com/p/shflags/
Source0:    http://shflags.googlecode.com/files/shflags-1.0.3.tgz

BuildArch:  noarch

Requires:       agetty cfdisk eject fdisk getopt hardlink hwclock look losetup lsblk mount msulogin rfkill schedutils setarch sfdisk util-linux
Source44: import.info

%description
Shell Flags (shFlags) is a library written to greatly simplify the handling of
command-line flags in Bourne based Unix shell scripts (bash, dash, ksh, sh, zsh)
on many Unix OSes (Linux, Solaris, Mac OS X, etc.).

Most shell scripts use getopt for flags processing, but the different versions
of getopt on various OSes make writing portable shell scripts difficult. shFlags
instead provides an API that doesn't change across shell and OS versions so the
script writer can be confident that the script will work.

shFlags is a port of the google-gflags C++/Python library.

%prep
%setup -q

# Make the examples non-executable.. we're putting them in /usr/share.
chmod -x examples/*.sh

%build
# This section is empty because this package ccontains shell scripts
# to be sourced: there's nothing to build

%check
pushd src
sh shflags_test_defines.sh
sh shflags_test_parsing.sh
sh shflags_test_public.sh
sh shflags_test_private.sh
sh shflags_test.sh
popd

%install
mkdir -p %{buildroot}/%{_datadir}/%{name}
cp -p src/shflags %{buildroot}/%{_datadir}/%{name}/.

%files
%doc README.txt README.html doc/ examples/
%{_datadir}/%{name}

%changelog
