Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/po4a /usr/bin/xsltproc libattr-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           shigofumi
Version:        0.9
Release:        alt2_8
Summary:        Command line client for accessing the Czech Data Boxes
# COPYING:          GPLv3 text
# README:           GPLv3+
# src/gettext.h:    LGPLv2+
# src/shigofumi.c:  GPLv3+
## Not in the binary packages
# aclocal.m4:       GPLv2+ with exceptions and FSFULLR
# compile:          GPLv2+ with exceptions
# config.sub:       GPLv3+ with exceptions
# config.guess:     GPLv3+ with exceptions
# config.rpath:     FSFULLR
# configure:        FSFUL
# depcomp:          GPLv2+ with exceptions
# doc/Makefile.in:  FSFULLR
# doc/po/cs/Makefile.in:    FSFULLR
# doc/po/Makefile.in:       FSFULLR
# install-sh:       MIT and Public DOmain
# m4/gettext.m4:    FSFULLR
# m4/host-cpu-c-abi.m4: FSFULLR
# m4/iconv.m4:      FSFULLR
# m4/intlmacosx.m4: FSFULLR
# m4/lib-ld.m4:     FSFULLR
# m4/lib-link.m4:   FSFULLR
# m4/lib-prefix.m4: FSFULLR
# m4/nls.m4:        FSFULLR
# m4/po.m4:         FSFULLR
# m4/progtest.m4:   FSFULLR
# m4/readline.m4:   GPL+ with exceptions
# Makefile.in:      FSFULLR
# missing:          GPLv2+ with exceptions
# po/insert-header.sin: FSFUL
# po/Makefile.in.in:    FSFUL
# po/remove-potcdate.sin:   FSFULLR
# po/Rules-quot:    FSFUL
# src/Makefile.in:  FSFULLR
# test/Makefile.in: FSFULLR
# test-driver:      GPLv2+ with exceptions
License:        GPLv3+ and LGPLv2+
URL:            http://xpisar.wz.cz/%{name}/
Source0:        http://xpisar.wz.cz/%{name}/dist/%{name}-%{version}.tar.xz
Source1:        http://xpisar.wz.cz/%{name}/dist/%{name}-%{version}.tar.xz.asc
# Key exported from Petr Pisar's keyring
Source2:        gpgkey-E3F42FCE156830A80358E6E94FD1AEC3365AF7BF.gpg
# Fix building with GCC 12, in upstream after 0.9
Patch0:         shigofumi-0.9-Fix-building-with-GCC-12.patch
# Fix use-after-frees when handling XML ISDS documents, in upstream after 0.9
Patch1:         shigofumi-0.9-Fix-two-use-after-frees-when-handling-XML-ISDS-docum.patch
# Adapt to changes in libxml2-2.12.0, in upstream after 0.9
Patch2:         shigofumi-0.9-Fix-building-with-libxml2-2.12.0.patch
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  libmagic-devel
BuildRequires:  gettext-tools libasprintf-devel
BuildRequires:  gcc
BuildRequires:  gnupg2
BuildRequires:  libxml2-devel
BuildRequires:  pkgconfig(libconfuse)
BuildRequires:  pkgconfig(libisds) >= 0.10.7
BuildRequires:  libreadline-devel
Source44: import.info

%description
This is Shigofumi, an ISDS (InformaA.nA. systA.m datovA.ch schrA.nek / Data Box
Information System) client.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1

autoreconf -fi

%build
%configure \
    --disable-debug \
    --enable-doc \
    --enable-fatalwarnings \
    --enable-largefile \
    --enable-nls \
    --disable-rpath \
    --enable-xattr
%{make_build}

%install
%{makeinstall_std}
%find_lang %{name}

%files -f %{name}.lang
%doc --no-dereference COPYING
%doc README AUTHORS NEWS TODO ChangeLog
%{_bindir}/shigofumi
%{_mandir}/man1/shigofumi.*
%{_mandir}/*/man1/shigofumi.*
%{_mandir}/man5/shigofumirc.*
%{_mandir}/*/man5/shigofumirc.*

%changelog
