# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/avr-as /usr/bin/avr-gcc /usr/bin/avr-ld /usr/bin/avr-nm /usr/bin/avr-objcopy /usr/bin/avr-objdump /usr/bin/makeinfo /usr/bin/pdftex /usr/bin/tex /usr/bin/texi2dvi /usr/bin/texindex libncurses-devel texlive-base-bin
# END SourceDeps(oneline)
%define fedora 19
# Only build noarch subpackages if distribution supports it
%if 0%{?fedora} >= 11
%global noarch_subpackage BuildArch: noarch
%else
%global noarch_subpackage %{nil}
%endif


Name:		simulavr
Version:	0.1.2.7
Release:	alt1_3
Summary:	An AVR Simulator

Group:		Development/Tools
License:	GPLv2+
URL:		http://savannah.nongnu.org/projects/simulavr/
Source0:	http://download.savannah.nongnu.org/releases/simulavr/%{name}-%{version}.tar.gz
# Allow overriding ENABLE_WARNINGS definition
Patch100:	0001-Allow-overriding-ENABLE_WARNINGS.patch
Patch200:	%{name}-%{version}-reset-LDFLAGS.patch

BuildRequires:	automake >= 1.11
BuildRequires:	automake < 1.12
BuildRequires:	avr-binutils
BuildRequires:	avr-gcc
BuildRequires:	avr-libc
BuildRequires:	bison
BuildRequires:	doxygen
BuildRequires:	flex
BuildRequires:	ncurses-devel
BuildRequires:	texi2html
BuildRequires:	texinfo
BuildRequires:	texinfo
Source44: import.info


%description
A simulator for microcontrollers from Atmel's AVR series.


%package doc
Group:		Development/Tools
Summary:	Documentation for simulavr (HTML and PDF)
# Source code derived docs are GPLv2+
# Texinfo stuff is OFSFDL
License:        GPLv2+ and OFSFDL
%{noarch_subpackage}


%description doc
A simulator for microcontrollers from Atmel's AVR series.

This subpackage contains the documentation in HTML and PDF format.


%prep
%setup -q
%patch100 -p1 -b .override-enable-warnings
%patch200 -p1 -b .reset-LDFLAGS
autoreconf -vis .


%build
%configure
# FIXME: Skip -Werror for now, as flex generated code ignores
# fwrite(3) return value which generates a warning.
# FIXME: Fix doc build race conditions exposed by ${?_smp_mflags}.
make ENABLE_WARNINGS="-Wall -Winline"


%install
rm -rf "%{buildroot}"
make install DESTDIR="%{buildroot}"
rm -f "%{buildroot}%{_infodir}/dir"
# Caution: We will not notice when anything new appears in docdir.
# So package maintainers need to be careful on updates.
mv "%{buildroot}%{_docdir}/%{name}-%{version}" docdir


%check
make DESTDIR="%{buildroot}" check


%files
%doc AUTHORS COPYING
%doc ChangeLog ChangeLog-2001 ChangeLog-2002 ChangeLog-2003
%doc ProjSummary README README.gdb README.opcodes TODO
%{_bindir}/simulavr
%{_bindir}/simulavr-disp
%{_bindir}/simulavr-vcd
%{_infodir}/simulavr.info.*
%{_mandir}/man1/simulavr-disp.1*
%{_mandir}/man1/simulavr.1*


%files doc
# License for the docs generated from the source
%doc COPYING
# The texinfo stuff contains embedded OFSFDL.
%doc docdir/html
%doc docdir/internals_html


%changelog
