Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Socket6.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:           Tiny IPv4 and IPv6 SIP redirect server written in Perl
Summary(de):       Ein winziger, in Perl geschriebener, SIP Redirekt-Server
Name:              sip-redirect
Version:           0.2.0
Release:           alt2_16
License:           GPLv2+
URL:               https://ftp.robert-scheck.de/linux/%{name}/
Source:            https://ftp.robert-scheck.de/linux/%{name}/%{name}-%{version}.tar.gz
BuildArch:         noarch
Requires:          logrotate
Requires:          perl(Socket.pm) >= 1.950
Requires(pre):     shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-log shadow-submap shadow-utils
BuildRequires:     rpm-build-perl
BuildRequires:     libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
Source44: import.info

%description
sip-redirect is a tiny SIP redirect server written in Perl. It is IPv4 and
IPv6 capable, but the IPv6 support is optional. The RFC 3261 was the base for
this simple and very configurable implementation. There is neither TCP nor
multicast support programmed in.

%description -l de
sip-redirect ist ein winziger, in Perl geschriebener, SIP Redirekt-Server. Er
unterstützt IPv4 und IPv6, aber der IPv6-Support ist optional. Als Grundlage
für diese einfache und sehr konfigurierbare Implementation wurde die RFC 3261
verwendet. Es wurde keine Unterstützung für TCP und für Multicast eingebaut.

%prep
%setup -q

%build

%install
%makeinstall_std
for rpm404_ghost in %{_localstatedir}/log/%{name}
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done


%pre
getent group sip > /dev/null || %{_sbindir}/groupadd -r sip
getent passwd sip > /dev/null || %{_sbindir}/useradd -r -g sip -d / -s /sbin/nologin -c "SIP redirect server" sip
exit 0

%post
touch %{_localstatedir}/log/%{name} > /dev/null 2>&1 || :
chown sip:sip %{_localstatedir}/log/%{name} > /dev/null 2>&1 || :
chmod 640 %{_localstatedir}/log/%{name} > /dev/null 2>&1 || :
%post_service %{name}

%preun
%preun_service %{name}

%files
%doc --no-dereference COPYING
%doc ChangeLog README
%{_bindir}/%{name}
%{_unitdir}/%{name}.service
%config(noreplace) %{_sysconfdir}/%{name}.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}
%ghost %attr(0640,sip,sip) %{_localstatedir}/log/%{name}

%changelog
