Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 7

Name:           sng
Version:        1.1.1
Release:        alt1_%autorelease
Summary:        Lossless editing of PNGs via a textual representation

License:        Zlib
URL:            https://sng.sourceforge.net/
Source0:        https://sourceforge.net/projects/sng/files/sng-%{version}.tar.xz

BuildRequires:  gcc
BuildRequires:  grep
BuildRequires:  libpng-devel libpng17-tools
BuildRequires:  zlib-devel
BuildRequires:  rgb
BuildRequires:  asciidoctor

Requires:       rgb
Source44: import.info

%description
SNG (Scriptable Network Graphics) is a minilanguage designed specifically to
represent the entire contents of a PNG (Portable Network Graphics) file in an
editable form. Thus, SNGs representing elaborate graphics images and ancillary
chunk data can be readily generated or modified using only text tools.

SNG is implemented by a compiler/decompiler called sng that losslessly
translates between SNG and PNG.

%prep
%setup -q

# Do not ignore specified linker flags
sed -r -i 's/LDFLAGS=/LDFLAGS+=/' Makefile

%build
%make_build

%install
%makeinstall_std prefix=%{_prefix}

%check
# Upstream has a test suite, but the test files are not packaged.
# Let's just check on the files that are in the tarball.
./sng_regress *.png *.sng

%files
%doc --no-dereference COPYING
%doc NEWS.adoc README TODO
%doc %_mandir/man1/sng.1*
%_bindir/sng

%changelog
